package project.web.auth;

import javax.servlet.http.HttpSession;

import online.model.ModelUtil;
import online.struts.action.BrowseAction;
import online.struts.action.UniForm;
import project.svc.auth.SessionInfo;


/**
 * ログオンアクション
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface LogonAction extends BrowseAction {

	/** ユーザー情報　ログオンタイム */
	String TAG_LOGON_TIME = "LOGON_TIME";
	/** ユーザー情報　ログオフタイム */
	String TAG_LOGOFF_TIME = "LOGOFF_TIME";
	/** ユーザー情報　ログオフの種類 */
	String TAG_LOGOFF_TYPE = "LOGOFF_TYPE";
	/** 継続実行（リクエスト先パス） */
	String TAG_CONTINUE_PATH = "CONTINUE_PATH";
	/** 継続実行（リクエスト先パラメタ） */
	String TAG_CONTINUE_QUERY = "CONTINUE_QUERY";

	/**
	 * ログオン情報設定
	 *
	 * @param li ログオン情報
	 * @param uf 汎用フォーム
	 * @param session セションオブジェクト
	 */
	default void setLogonInfoToSession(final SessionInfo li,
			final UniForm uf, final HttpSession session) {
		// ログオン時間
		session.setAttribute(TAG_LOGON_TIME, li.getLogonDateTime());
		// ログオフ時間
		session.setAttribute(TAG_LOGOFF_TIME, li.getLogoffDateTime());
		// ログオフ形態
		session.setAttribute(TAG_LOGOFF_TYPE, li.getLogoffType());
		// メッセージ
		session.setAttribute(ModelUtil.TAG_MESSAGE, uf.getStringArray(ModelUtil.TAG_MESSAGE));
		session.setAttribute(ModelUtil.TAG_STATUS, uf.getStringArray(ModelUtil.TAG_STATUS));
	}
}
