package project.web.generic.master;

import online.annotation.SessionExit;
import online.annotation.SessionReserved;
import online.struts.action.BrowseAction;
import online.struts.action.UniForm;
import project.master.MsgUtil;
import project.svc.generic.db.RecordOperate;
import project.web.InstanceFactory;

/**
 * 汎用更新確認画面
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class ConfirmUpdateAction implements BrowseAction {

	/** キー項目 */
	@SessionReserved
	private static final String ID = "Id";
	/** キー項目 */
	@SessionReserved
	private static final String VERSION = "Version";
	/** 終了メッセージ */
	private static final String RESULT_MESSAGE = "ResultMessage";

	/**
	 * 確定処理
	 *
	 * @param model 汎用モデル
	 * @return 処理結果
	 */
	@SessionExit
	public String commit(final UniForm model) {
		final var ro = InstanceFactory.create(RecordOperate.class, model);
		if (!model.hasValue(ID)) {
			if (!ro.insert(model)) {
				// 排他エラー
				MsgUtil.putTopMessage(model, "ZZ000000015");
				return ID_NG;
			}
		} else {
			if (!ro.update(model.getNumber(ID), model.getNumber(VERSION), model)) {
				// レコード不在、バージョン不一致
				MsgUtil.putTopMessage(model, "ZZ000000016");
				return ID_NG;
			}
		}

		model.setValue(RESULT_MESSAGE, "正常終了");

		return ID_OK;
	}
}
