package project.web.job;

import java.util.Objects;

import batch.controller.JobRequestor;
import batch.status.JobStatus;
import common.db.JdbcSource;
import core.config.Factory;
import online.context.check.InputCheck;
import online.struts.action.BrowseAction;
import online.struts.action.UniForm;
import project.check.attribute.LongNumeralCheck;
import project.check.existence.MustCheck;
import project.web.InstanceFactory;
import project.web.generic.SearchAction;

/**
 * バッチ状況照会画面
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class StatusAction implements BrowseAction {

	/** JobSeq */
	private static final String JOB_SEQ = "JobSeq";

	/** クエリ */
	private String query = null;

	/**
	 * クエリ設定
	 *
	 * @param qry クエリファイル
	 */
	public void setQueryFile(final String qry) {
		this.query = qry;
	}

	/**
	 * 表示処理
	 *
	 * @param model 汎用データモデル
	 * @return 処理結果
	 */
	public String get(final UniForm model) {
		final var action = new SearchAction();
		action.setQueryFile(this.query);
		return action.get(model);
	}

	/**
	 * バッチ中止処理
	 *
	 * @param model 汎用モデル
	 * @return 処理結果
	 */
	public String cancel(final UniForm model) {

		final var ic = InstanceFactory.create(InputCheck.class, model);
		ic.add(JOB_SEQ, new MustCheck());
		ic.add(JOB_SEQ, new LongNumeralCheck());
		ic.populate();

		try (var conn = JdbcSource.getConnection()) {
			final var js = Factory.create(JobStatus.class);
			final var job = js.getJob(conn, model.getNumber(JOB_SEQ).longValue());

			final var su = model.getSessionUser();
			if (Objects.equals(job.getUid(), su.getUid())) {
				// 中止処理呼出
				JobRequestor.cancelJob(model.getNumber(JOB_SEQ).longValue());
			}
		}
		return ID_OK;
	}
}
