<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="UTF-8" />
<title>バッチ状況照会</title>
<link rel="stylesheet" href="${CONTEXT}/view/css/import.css" />
</head>

<body>
<header>
	<nav>
		<ul>
			<li><a href="menu.do">メニュー</a></li>
			<li><a href="logoff.do">ログオフ</a></li>
		</ul>
	</nav>
</header>
<main>
	<header>
		<h3>バッチ状況</h3>
		<div id="topMessage">${MESSAGE}</div>
	</header>
	<section>
		<c:if test="${fn:length(array.PatternValue) gt 0}">
		<form id="pattern" method="get" action="${ACTION_PATH}">
		<div>
			<label>検索パターン:</label>
			<select name="PatternId">
			<option></option>
			<c:forEach items="${band.PatternValue}" var="bind">
				<utl:selected var="sel" name="PatternId" value="${bind.PatternValue}" />
				<option value="${sel}">${bind.PatternLabel}</option>
			</c:forEach>
			</select>
			<button type="button" class="search">検索</button>
			<button type="button" class="csv">CSV</button>
		</div>

		<div>
			<a href="javascript:void(0);" class="detail">詳細検索</a>
		</div>
		</form>
		</c:if>

		<div id="detail">
			<form id="search" method="get" action="${ACTION_PATH}">
			<label>ユーザID:</label>
			<input type="text" name="UserIdSearch" value="${UserIdSearch}" />
			<button type="submit">検索</button>
			<button type="button" class="csv">CSV</button>
			</form>

		<c:if test="${fn:length(REQUEST_QUERY) gt 0}">
			<form id="register" method="post">
			<div>検索パターン登録</div>
			<div>
				<input type="hidden" name="PatternQuery" value="${RESPONSE_QUERY}" />
				<input type="text" name="PatternName" maxlength="64" />
				<input id="defaultPattern" type="checkbox" name="DefaultPattern" />
				<label for="defaultPattern">優先</label>
				<button type="button" class="register">パターン登録</button>
			</div>
			</form>
		</c:if>
		</div>

		<div>
			<c:if test="${not empty JobMei}" >
			<div>${Cnt} 件</div>
			<tags:paginator />
			<div>
				<table class="fixborder" >
				<thead>
					<tr>
						<th rowspan="3">No</th>
						<th>処理ID</th>
						<th>処理名称</th>
						<th>受付日時</th>
						<th>依頼者</th>
						<th rowspan="3">処理状況</th>
					</tr>
					<tr>
						<th colspan="4">指示内容</th>
					</tr>
					<tr>
						<th colspan="4">メッセージ</th>
					</tr>
				</thead>
				<c:forEach begin="0" items="${band.JobMei}" var="bind" varStatus="sts">
				<tbody class="stripe">
					<tr>
						<td rowspan="3" class="center">
							${sts.count + ((Page - 1) * Line)}
						</td>
						<td>
<!--
							<utl:param var="prm" name="Page,JobSeq,PatternId" value="${Page},${bind.JobSeq}," />
-->
							<utl:param var="prm" name="JobSeq" value="${bind.JobSeq}" />
							<a href="${DETAIL_PATH}?${prm}">${bind.JobId}</a>
						</td>
						<td class="center">
							<c:set var="val" value="${empty bind.JobMei ? '-' : bind.JobMei}" />
							${val}
						</td>
						<td class="center">
							<c:set var="val" value="${empty bind.TorokuDtm ? '-' : bind.TorokuDtm}" />
							${val}
						</td>
						<td class="center">
							<c:set var="val" value="${empty bind.UserId ? '-' : bind.UserId}" />
							${val}
						</td>
						<td rowspan="3" class="center">
							<tags:state var="val" value="${bind.JobSts}" />
							${val}
							<c:if test="${(bind.JobSts lt 40) and (bind.CancelType eq '1')}">
								<form id="form${sts.index}" method="post">
								<input type="hidden" name="JobSeq" value="${bind.JobSeq}" />
									<button type="button" class="cancel">中止</button>
								</form>
							</c:if>
						</td>
					</tr>
					<tr>
						<td colspan="4" class="center">
							<c:set var="val" value="${empty bind.GamenPrm ? '-' : bind.GamenPrm}" />
							${val}
						</td>
					</tr>
					<tr>
						<td colspan="4" class="center">
							<c:set var="val" value="${empty bind.MsgTxt ? '-' : bind.MsgTxt}" />
							${val}
						</td>
					</tr>
				</tbody>
				</c:forEach>
				</table>
			</div>
			</c:if>
		</div>
	</section>
	<aside>
	</aside>
	<footer>
	</footer>
</main>
<footer>
	<nav>
	</nav>
	<section>
	</section>
</footer>

<script src="${CONTEXT}/view/js/jquery.min.js"></script>
<!-- <script src="${CONTEXT}/view/js/opt/jquery.jstore-all.min.js"></script> -->
<script src="${CONTEXT}/view/js/submit.js"></script>
<script src="${CONTEXT}/view/js/job/status.js"></script>
</body>
</html>
