package common.db.dao;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * DaoUtilTest
 *
 */
public class DaoUtilTest {

	/**
	 * DB名正常テスト
	 */
	@DisplayName("DB名正常")
	@Test
	public void testToDBName() {
		Assertions.assertEquals("AAA_BBB", DaoUtil.toDBName("AaaBbb"));
		Assertions.assertEquals("AAA_B_4BB", DaoUtil.toDBName("AaaB4bb"));
		Assertions.assertEquals("AAA_B_45_BB", DaoUtil.toDBName("AaaB45Bb"));
	}
}
