package common.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

/**
 * QueryUtilTest
 *
 * @author Tadashi Nakayama
 */
public class QueryUtilTest {

	/**
	 * case1
	 */
	@Test
	public void testToPrepareQuery() {
		final Object[] vals = new Object[]{"aaaa", "bbbb"};
		final Map<String, Object> map = Stream.of(vals).collect(HashMap::new,
				(m, v) -> m.put(String.valueOf(m.size() + 1), v), HashMap::putAll);

		Assertions.assertEquals("aaaa", Objects.toString(map.get("1")));
		Assertions.assertEquals("bbbb", Objects.toString(map.get("2")));

		final List<Object> list = new ArrayList<>();
		QueryUtil.toPrepareQuery(
				"SELECT \n"
				+ "  VERSION \n"
				+ "FROM \n"
				+ "  FW_JOB_REPEAT \n"
				+ "WHERE \n"
				+ "  D = /*:1*/'1223' \n"
				+ "  AND ID = 1223 \n",
				map, list);

		Assertions.assertEquals(1, list.size());
		Assertions.assertEquals("aaaa", list.get(0));
	}

	/**
	 * case2
	 */
	@Test
	public void getCodeMaster() {
		final String query = "select * from ms_code where cd_sbt = /*:1*/'' order by cd_sbt, cd ";

		final Map<String, String> param = new HashMap<>();
		param.put("1", "value");

		final List<Object> list = new ArrayList<>();
		QueryUtil.toPrepareQuery(query, param, list);

		Assertions.assertEquals(1, list.size());
		Assertions.assertEquals("value", list.get(0));
	}
}
