package common.sql;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * TestLineParsedNodeItem
 *
 */
public class TestLineParsedNodeItem {

	/**
	 * 括弧パースOFFSET_LIMIT句
	 */
	@Test
	@DisplayName("括弧パースOFFSET_LIMIT句")
	public void testLineParsedNodeItem1() {
		final LineParsedNodeItem sut = new LineParsedNodeItem(
				"OFFSET ((/*?Page*/1 - 1) * /*?Line*/20 ) LIMIT /*?Line*/20 \n");
		Assertions.assertEquals(
				"OFFSET ( ( /*?Page*/1 - 1 ) * /*?Line*/20 ) LIMIT /*?Line*/20", sut.toString());
	}

	/**
	 * 括弧パースAND
	 */
	@Test
	@DisplayName("括弧パースAND")
	public void testLineParsedNodeItem2() {
		final LineParsedNodeItem sut = new LineParsedNodeItem(
			"AND ((DT_DATTAI_YM = '      ' ) (( DT_DATTAI_YM >= ))/*:dtGyomu*/'200901' )");
		Assertions.assertEquals(
				"AND ( ( DT_DATTAI_YM = '      ' )( ( DT_DATTAI_YM >= ) ) /*:dtGyomu*/'200901' )",
				sut.toString());
	}

	/**
	 * 括弧パース
	 */
	@Test
	@DisplayName("括弧パース")
	public void testLineParsedNodeItem3() {
		final LineParsedNodeItem sut = new LineParsedNodeItem(
			"AND (DT_DATTAI_YM = '      ' OR DT_DATTAI_YM >= /*:dtGyomu*/'200901')");
		Assertions.assertEquals(
				"AND ( DT_DATTAI_YM = '      ' OR DT_DATTAI_YM >= /*:dtGyomu*/'200901' )",
				sut.toString());
	}

	/**
	 * 括弧パースAND_OR
	 */
	@Test
	@DisplayName("括弧パースAND_OR")
	public void testLineParsedNodeItem4() {
		final LineParsedNodeItem sut = new LineParsedNodeItem(
			"AND ((DT_DATTAI_YM = '      ' AND MN_PAY > /*:mnPay*/1 ) "
			+ "OR (DT_DATTAI_YM >= /*:dtGyomu*/'200901' ))");
		Assertions.assertEquals(
				"AND ( ( DT_DATTAI_YM = '      ' AND MN_PAY > /*:mnPay*/1 ) "
				+ "OR ( DT_DATTAI_YM >= /*:dtGyomu*/'200901' ) )",
				sut.toString());
	}

	/**
	 * 日時必須パース
	 */
	@Test
	@DisplayName("日時必須パース")
	public void testLineParsedNodeItem5() {
		final LineParsedNodeItem sut = new LineParsedNodeItem(
				"UPDATE_DATETIME = /*:DateTime*/TO_DATE('20091225','YYYYMMDD') ,");
		Assertions.assertEquals(
				"UPDATE_DATETIME = /*:DateTime*/TO_DATE( '20091225','YYYYMMDD' ) ,",
				sut.toString());
	}

	/**
	 * 日時必須パースAND_OR句
	 */
	@Test
	@DisplayName("日時必須パースAND_OR句")
	public void testLineParsedNodeItem6() {
		final LineParsedNodeItem sut = new LineParsedNodeItem(
			"AND ((DT_DATTAI_YM = /*:DateTime*/TO_DATE('20091225','YYYYMMDD') "
			+ "AND MN_PAY > /*:mnPay*/0 ) OR (DT_DATTAI_YM >= /*:dtGyomu*/'200901' ))");
		Assertions.assertEquals(
				"AND ( ( DT_DATTAI_YM = /*:DateTime*/TO_DATE( '20091225','YYYYMMDD' ) "
				+ "AND MN_PAY > /*:mnPay*/0 ) OR ( DT_DATTAI_YM >= /*:dtGyomu*/'200901' ) )",
				sut.toString());
	}

	/**
	 * getBindString行末スペース
	 */
	@Test
	@DisplayName("getBindString行末スペース")
	public void testLineParsedNodeItem7() {
		final LineParsedNodeItem sut = new LineParsedNodeItem("");
		Assertions.assertEquals("aaaaa#12345", sut.getBindString("aaaaa#12345)", 0));
		Assertions.assertEquals("aaaaa#0.00012", sut.getBindString("aaaaa#0.00012, ", 0));
		Assertions.assertEquals("aaaaa#-1234", sut.getBindString("aaaaa#-1234 ", 0));
		Assertions.assertEquals("aaaaa#-1234.53", sut.getBindString("aaaaa#-1234.53 ", 0));
		Assertions.assertEquals("aaaaa#-0.53", sut.getBindString("aaaaa#-0.53 ", 0));
		Assertions.assertEquals("aaaaa#-0.00", sut.getBindString("aaaaa#-0.00  ", 0));
	}
}
