package online.model;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

/**
 * TestModelUtil
 *
 */
public class TestModelUtil {

	/**
	 * Bean項目→UniModel設定テスト１
	 */
	@Test
	@DisplayName("Bean項目→UniModel設定テスト１")
	public void setBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "String");
		ModelUtil.setBeanItemValue(um, bean, "StringArray");

		Assertions.assertTrue(um.containsKey("String"));
		Assertions.assertFalse(um.hasValue("String"));
		Assertions.assertEquals("", um.getString("String"));
		Assertions.assertEquals(0, um.getArraySize("String"));
		Assertions.assertEquals(0, um.getStringArray("String").length);
		Assertions.assertFalse(um.isArrayValue("String"));

		Assertions.assertTrue(um.containsKey("StringArray"));
		Assertions.assertFalse(um.hasValue("StringArray"));
		Assertions.assertEquals("", um.getString("StringArray"));
		Assertions.assertEquals(0, um.getArraySize("StringArray"));
		Assertions.assertEquals(0, um.getStringArray("StringArray").length);
		Assertions.assertTrue(um.isArrayValue("StringArray"));
	}

	/**
	 * Bean項目→UniModel設定テスト２
	 */
	@Test
	@DisplayName("Bean項目→UniModel設定テスト２")
	public void setBeanItemValueTest2() {
		final JavaBean bean = new JavaBean();
		bean.setString("AAAAA");
		bean.setStringArray("AAAAA");
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "String");
		ModelUtil.setBeanItemValue(um, bean, "StringArray");

		Assertions.assertTrue(um.containsKey("String"));
		Assertions.assertTrue(um.hasValue("String"));
		Assertions.assertEquals("AAAAA", um.getString("String"));
		Assertions.assertEquals(1, um.getArraySize("String"));
		Assertions.assertEquals(1, um.getStringArray("String").length);
		Assertions.assertFalse(um.isArrayValue("String"));

		Assertions.assertTrue(um.containsKey("StringArray"));
		Assertions.assertTrue(um.hasValue("StringArray"));
		Assertions.assertEquals("AAAAA", um.getString("StringArray"));
		Assertions.assertEquals(1, um.getArraySize("StringArray"));
		Assertions.assertEquals(1, um.getStringArray("StringArray").length);
		Assertions.assertTrue(um.isArrayValue("StringArray"));
	}


	/**
	 * Bean項目→UniModel追加テスト１
	 */
	@Test
	@DisplayName("Bean項目→UniModel追加テスト１")
	public void addBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "String");
		ModelUtil.addBeanItemValue(um, bean, "StringArray");

		Assertions.assertTrue(um.containsKey("String"));
		Assertions.assertTrue(um.hasValue("String"));
		Assertions.assertEquals("", um.getString("String"));
		Assertions.assertEquals(1, um.getArraySize("String"));
		Assertions.assertEquals(1, um.getStringArray("String").length);
		Assertions.assertFalse(um.isArrayValue("String"));

		Assertions.assertTrue(um.containsKey("StringArray"));
		Assertions.assertTrue(um.hasValue("StringArray"));
		Assertions.assertNull(um.getStringArray("StringArray")[0]);
		Assertions.assertEquals(1, um.getArraySize("StringArray"));
		Assertions.assertEquals(1, um.getStringArray("StringArray").length);
		Assertions.assertTrue(um.isArrayValue("StringArray"));
	}

	/**
	 * Bean項目→UniModel追加テスト２
	 */
	@Test
	@DisplayName("Bean項目→UniModel追加テスト２")
	public void addBeanItemValueTest2() {
		final JavaBean bean = new JavaBean();
		bean.setString("AAAAA");
		bean.setStringArray("AAAAA");
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "String");
		ModelUtil.addBeanItemValue(um, bean, "StringArray");

		Assertions.assertTrue(um.containsKey("String"));
		Assertions.assertTrue(um.hasValue("String"));
		Assertions.assertEquals("AAAAA", um.getString("String"));
		Assertions.assertEquals(1, um.getArraySize("String"));
		Assertions.assertEquals(1, um.getStringArray("String").length);
		Assertions.assertFalse(um.isArrayValue("String"));

		Assertions.assertTrue(um.containsKey("StringArray"));
		Assertions.assertTrue(um.hasValue("StringArray"));
		Assertions.assertEquals("AAAAA", um.getStringArray("StringArray")[0]);
		Assertions.assertEquals(1, um.getArraySize("StringArray"));
		Assertions.assertEquals(1, um.getStringArray("StringArray").length);
		Assertions.assertTrue(um.isArrayValue("StringArray"));
	}


	/**
	 * UniModel→Bean設定テスト（空）
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト（空）")
	public void setModelValueTest1() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um);

		Assertions.assertNull(bean.getString());
		Assertions.assertNull(bean.getStringArray());
	}

	/**
	 * UniModel→Bean設定テスト(String->String)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(String->String)")
	public void setModelValueTest2() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", "AAAAA");
		um.setValue("StringArray", new String[]{"AAAAA"});
		ModelUtil.setModelValue(bean, um);

		Assertions.assertEquals("AAAAA", bean.getString());
		Assertions.assertEquals("AAAAA", bean.getStringArray()[0]);
	}

	/**
	 * UniModel→Bean設定テスト(String->Boolean)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(String->Boolean)")
	public void setModelValueTest3() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBooleanArray", "ZZZZ", "TRUE");
		um.setValue("BooleanArray", "ZZZZ", "TRUE");
		ModelUtil.setModelValue(bean, um);

		Assertions.assertFalse(bean.isPrimitiveBooleanArray()[0]);
		Assertions.assertTrue(bean.isPrimitiveBooleanArray()[1]);
		Assertions.assertEquals(Boolean.FALSE, bean.isBooleanArray()[0]);
		Assertions.assertEquals(Boolean.TRUE, bean.isBooleanArray()[1]);
	}

	/**
	 * UniModel→Bean設定テスト(String->Integer)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(String->Integer)")
	public void setModelValueTest4() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveIntegerArray", "111", "222");
		um.setValue("IntegerArray", "333", "444");
		ModelUtil.setModelValue(bean, um);

		Assertions.assertEquals(111, bean.getPrimitiveIntegerArray()[0]);
		Assertions.assertEquals(222, bean.getPrimitiveIntegerArray()[1]);
		Assertions.assertEquals(Integer.valueOf(333), bean.getIntegerArray()[0]);
		Assertions.assertEquals(Integer.valueOf(444), bean.getIntegerArray()[1]);
	}

	/**
	 * UniModel→Bean設定テスト(値あり->空)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(値あり->空)")
	public void setModelValueTest5() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray("aaaa");

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", (String[])null);
		ModelUtil.setModelValue(bean, um);

		Assertions.assertNull(bean.getString());
		Assertions.assertNotNull(bean.getStringArray());
		Assertions.assertEquals(0, bean.getStringArray().length);
	}

	/**
	 * UniModel→Bean設定テスト(値あり->空配列)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(値あり->空配列)")
	public void setModelValueTest6() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray("aaaa");

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", new String[0]);
		ModelUtil.setModelValue(bean, um);

		Assertions.assertNull(bean.getString());
		Assertions.assertNotNull(bean.getStringArray());
		Assertions.assertEquals(0, bean.getStringArray().length);
	}

	/**
	 * UniModel→Bean設定テスト(値あり->空)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(値あり->空)")
	public void setModelValueTest7() {
		final JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray("String");

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", (String)null);

		ModelUtil.setModelValue(bean, um);

		Assertions.assertNull(bean.getString());
		Assertions.assertNotNull(bean.getStringArray());
		Assertions.assertEquals(1, bean.getStringArray().length);
		Assertions.assertNull(bean.getStringArray()[0]);
	}

	/**
	 * UniModel→Bean設定テスト(値あり->文字列)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(値あり->文字列)")
	public void setModelValueTest8() {
		final JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray("String");

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", "aaaa");
		um.setValue("StringArray", "bbbb");

		ModelUtil.setModelValue(bean, um);

		Assertions.assertEquals("aaaa", bean.getString());
		Assertions.assertNotNull(bean.getStringArray());
		Assertions.assertEquals(1, bean.getStringArray().length);
		Assertions.assertEquals("bbbb", bean.getStringArray()[0]);
	}


	/**
	 * UniModel→Bean設定テスト(空)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(空)")
	public void setModelValueTest10() {
		final JavaBean bean = new JavaBean();
		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.getString());
		Assertions.assertNull(bean.getStringArray());
	}

	/**
	 * UniModel→Bean設定テスト(String配列→String)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(String配列→String)")
	public void setModelValueTest11() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", "ZZZZ", "AAAAA");
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertEquals("AAAAA", bean.getString());
	}

	/**
	 * UniModel→Bean設定テスト(String配列→Boolean)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(String配列→Boolean)")
	public void setModelValueTest12() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveBoolean", "ZZZZ", "TRUE");
		um.setValue("Boolean", "ZZZZ", "TRUE");
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.isPrimitiveBooleanArray());
		Assertions.assertNull(bean.isBooleanArray());
		Assertions.assertTrue(bean.isPrimitiveBoolean());
		Assertions.assertEquals(Boolean.TRUE, bean.isBoolean());
	}

	/**
	 * UniModel→Bean設定テスト(String配列→int)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(String配列→int)")
	public void setModelValueTest13() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", "1111", "2,222");
		um.setValue("Integer", "3333", "4444");
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.getPrimitiveIntegerArray());
		Assertions.assertNull(bean.getIntegerArray());
		Assertions.assertEquals(2222, bean.getPrimitiveInteger());
		Assertions.assertEquals(Integer.valueOf(4444), bean.getInteger());
	}

	/**
	 * UniModel→Bean設定テスト(String配列→int非数値)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(String配列→int非数値)")
	public void setModelValueTest14() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", "1111", ",,");
		um.setValue("Integer", "3333", ",");
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.getPrimitiveIntegerArray());
		Assertions.assertNull(bean.getIntegerArray());
		Assertions.assertEquals(0, bean.getPrimitiveInteger());
		Assertions.assertNull(bean.getInteger());
	}

	/**
	 * UniModel→Bean設定テスト(String配列→null)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(String配列→null)")
	public void setModelValueTest15() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray("aaaa");

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", (String[])null);
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.getString());
		Assertions.assertNotNull(bean.getStringArray());
		Assertions.assertEquals(0, bean.getStringArray().length);
	}

	/**
	 * UniModel→Bean設定テスト(String配列→空配列)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(String配列→空配列)")
	public void setModelValueTest16() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray("aaaa");

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", (String)null);
		um.setValue("StringArray", new String[0]);
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.getString());
		Assertions.assertNotNull(bean.getStringArray());
		Assertions.assertEquals(0, bean.getStringArray().length);
	}

	/**
	 * UniModel→Bean設定テスト(値無し)
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト(値無し)")
	public void setModelValueTest20() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray("aaaa");

		final UniModelImpl um = new UniModelImpl();
		um.noValue("String");
		um.noValue("StringArray");
		ModelUtil.setModelValue(bean, um);

		Assertions.assertNull(bean.getString());
		Assertions.assertNull(bean.getStringArray());
	}

	/**
	 * UniModel→Bean設定テスト
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト")
	public void setModelValueTest21() {
		final JavaBean bean = new JavaBean();
		bean.setString("aaaa");
		bean.setStringArray("aaaa");

		final UniModelImpl um = new UniModelImpl();
		um.noValue("String");
		um.noValue("StringArray");

		ModelUtil.setModelValue(bean, um, 0);

		Assertions.assertNull(bean.getString());
		Assertions.assertNull(bean.getStringArray());

		bean.setString("aaaa");
		bean.setStringArray("aaaa");
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertNull(bean.getString());
		Assertions.assertNull(bean.getStringArray());
	}

	/**
	 * UniModel→Bean設定テスト
	 */
	@Test
	@DisplayName("UniModel→Bean設定テスト")
	public void setModelValueTest31() {
		final JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray("String");

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", "aaaa", "bbbb");
		um.setValue("StringArray", "aaaa", "bbbb");

		ModelUtil.setModelValue(bean, um, 2);

		Assertions.assertEquals("String", bean.getString());
		Assertions.assertNotNull(bean.getStringArray());
		Assertions.assertEquals(2, bean.getStringArray().length);
		Assertions.assertEquals("aaaa", bean.getStringArray()[0]);
		Assertions.assertEquals("bbbb", bean.getStringArray()[1]);
	}
}
