package online.model;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

/**
 * TestModelUtilNumber
 *
 */
public class TestModelUtilNumber {

	/**
	 * setBeanItemValueTest1
	 */
	@Test
	public void setBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveInteger");
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveIntegerArray");
		ModelUtil.setBeanItemValue(um, bean, "Integer");
		ModelUtil.setBeanItemValue(um, bean, "IntegerArray");

		Assertions.assertTrue(um.containsKey("PrimitiveInteger"));
		Assertions.assertTrue(um.hasValue("PrimitiveInteger"));
		Assertions.assertEquals(Integer.valueOf(0), um.getNumber("PrimitiveInteger"));
		Assertions.assertEquals(1, um.getArraySize("PrimitiveInteger"));
		Assertions.assertEquals(1, um.getNumberArray("PrimitiveInteger").length);
		Assertions.assertFalse(um.isArrayValue("PrimitiveInteger"));

		Assertions.assertTrue(um.containsKey("PrimitiveIntegerArray"));
		Assertions.assertFalse(um.hasValue("PrimitiveIntegerArray"));
		Assertions.assertNull(um.getNumber("PrimitiveIntegerArray"));
		Assertions.assertEquals(0, um.getArraySize("PrimitiveIntegerArray"));
		Assertions.assertEquals(0, um.getNumberArray("PrimitiveIntegerArray").length);
		Assertions.assertTrue(um.isArrayValue("PrimitiveIntegerArray"));

		Assertions.assertTrue(um.containsKey("Integer"));
		Assertions.assertFalse(um.hasValue("Integer"));
		Assertions.assertNull(um.getNumber("Integer"));
		Assertions.assertEquals(0, um.getArraySize("Integer"));
		Assertions.assertEquals(0, um.getNumberArray("Integer").length);
		Assertions.assertFalse(um.isArrayValue("Integer"));

		Assertions.assertTrue(um.containsKey("IntegerArray"));
		Assertions.assertFalse(um.hasValue("IntegerArray"));
		Assertions.assertNull(um.getNumber("IntegerArray"));
		Assertions.assertEquals(0, um.getArraySize("IntegerArray"));
		Assertions.assertEquals(0, um.getNumberArray("IntegerArray").length);
		Assertions.assertTrue(um.isArrayValue("IntegerArray"));
	}

	/**
	 * setBeanItemValueTest2
	 */
	@Test
	public void setBeanItemValueTest2() {
		final JavaBean bean = new JavaBean();
		bean.setPrimitiveInteger(100);
		bean.setPrimitiveIntegerArray(new int[]{111, 999});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveInteger");
		ModelUtil.setBeanItemValue(um, bean, "PrimitiveIntegerArray");

		Assertions.assertTrue(um.containsKey("PrimitiveInteger"));
		Assertions.assertTrue(um.hasValue("PrimitiveInteger"));
		Assertions.assertEquals(Integer.valueOf(100), um.getNumber("PrimitiveInteger"));
		Assertions.assertEquals(1, um.getArraySize("PrimitiveInteger"));
		Assertions.assertEquals(1, um.getNumberArray("PrimitiveInteger").length);
		Assertions.assertFalse(um.isArrayValue("PrimitiveInteger"));

		Assertions.assertTrue(um.containsKey("PrimitiveIntegerArray"));
		Assertions.assertTrue(um.hasValue("PrimitiveIntegerArray"));
		Assertions.assertEquals(Integer.valueOf(111), um.getNumber("PrimitiveIntegerArray"));
		Assertions.assertEquals(2, um.getArraySize("PrimitiveIntegerArray"));
		Assertions.assertEquals(2, um.getNumberArray("PrimitiveIntegerArray").length);
		Assertions.assertTrue(um.isArrayValue("PrimitiveIntegerArray"));
	}

	/**
	 * setBeanItemValueTest3
	 */
	@Test
	public void setBeanItemValueTest3() {
		final JavaBean bean = new JavaBean();
		bean.setInteger(200);
		bean.setIntegerArray(new Integer[]{222, 888});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setBeanItemValue(um, bean, "Integer");
		ModelUtil.setBeanItemValue(um, bean, "IntegerArray");

		Assertions.assertTrue(um.containsKey("Integer"));
		Assertions.assertTrue(um.hasValue("Integer"));
		Assertions.assertEquals(Integer.valueOf(200), um.getNumber("Integer"));
		Assertions.assertEquals(1, um.getArraySize("Integer"));
		Assertions.assertEquals(1, um.getNumberArray("Integer").length);
		Assertions.assertFalse(um.isArrayValue("Integer"));

		Assertions.assertTrue(um.containsKey("IntegerArray"));
		Assertions.assertTrue(um.hasValue("IntegerArray"));
		Assertions.assertEquals(Integer.valueOf(222), um.getNumber("IntegerArray"));
		Assertions.assertEquals(2, um.getArraySize("IntegerArray"));
		Assertions.assertEquals(2, um.getNumberArray("IntegerArray").length);
		Assertions.assertTrue(um.isArrayValue("IntegerArray"));
	}


	/**
	 * addBeanItemValueTest1
	 */
	@Test
	public void addBeanItemValueTest1() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveInteger");
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveIntegerArray");
		ModelUtil.addBeanItemValue(um, bean, "Integer");
		ModelUtil.addBeanItemValue(um, bean, "IntegerArray");

		Assertions.assertTrue(um.containsKey("PrimitiveInteger"));
		Assertions.assertTrue(um.hasValue("PrimitiveInteger"));
		Assertions.assertEquals(Integer.valueOf(0), um.getNumber("PrimitiveInteger"));
		Assertions.assertEquals(1, um.getArraySize("PrimitiveInteger"));
		Assertions.assertEquals(1, um.getNumberArray("PrimitiveInteger").length);
		Assertions.assertFalse(um.isArrayValue("PrimitiveInteger"));

		Assertions.assertTrue(um.containsKey("PrimitiveIntegerArray"));
		Assertions.assertTrue(um.hasValue("PrimitiveIntegerArray"));
		Assertions.assertNull(um.getNumber("PrimitiveIntegerArray"));
		Assertions.assertEquals(1, um.getArraySize("PrimitiveIntegerArray"));
		Assertions.assertEquals(1, um.getNumberArray("PrimitiveIntegerArray").length);
		Assertions.assertTrue(um.isArrayValue("PrimitiveIntegerArray"));

		Assertions.assertTrue(um.containsKey("Integer"));
		Assertions.assertTrue(um.hasValue("Integer"));
		Assertions.assertNull(um.getNumber("Integer"));
		Assertions.assertEquals(1, um.getArraySize("Integer"));
		Assertions.assertEquals(1, um.getNumberArray("Integer").length);
		Assertions.assertFalse(um.isArrayValue("Integer"));

		Assertions.assertTrue(um.containsKey("IntegerArray"));
		Assertions.assertTrue(um.hasValue("IntegerArray"));
		Assertions.assertNull(um.getNumber("IntegerArray"));
		Assertions.assertEquals(1, um.getArraySize("IntegerArray"));
		Assertions.assertEquals(1, um.getNumberArray("IntegerArray").length);
		Assertions.assertTrue(um.isArrayValue("IntegerArray"));
	}

	/**
	 * addBeanItemValueTest2
	 */
	@Test
	public void addBeanItemValueTest2() {
		final JavaBean bean = new JavaBean();
		bean.setPrimitiveInteger(100);
		bean.setPrimitiveIntegerArray(new int[]{111, 999});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveInteger");
		ModelUtil.addBeanItemValue(um, bean, "PrimitiveIntegerArray");

		Assertions.assertTrue(um.containsKey("PrimitiveInteger"));
		Assertions.assertTrue(um.hasValue("PrimitiveInteger"));
		Assertions.assertEquals(Integer.valueOf(100), um.getNumber("PrimitiveInteger"));
		Assertions.assertEquals(1, um.getArraySize("PrimitiveInteger"));
		Assertions.assertEquals(1, um.getNumberArray("PrimitiveInteger").length);
		Assertions.assertFalse(um.isArrayValue("PrimitiveInteger"));

		Assertions.assertTrue(um.containsKey("PrimitiveIntegerArray"));
		Assertions.assertTrue(um.hasValue("PrimitiveIntegerArray"));
		Assertions.assertEquals(Integer.valueOf(111), um.getNumber("PrimitiveIntegerArray"));
		Assertions.assertEquals(2, um.getArraySize("PrimitiveIntegerArray"));
		Assertions.assertEquals(2, um.getNumberArray("PrimitiveIntegerArray").length);
		Assertions.assertTrue(um.isArrayValue("PrimitiveIntegerArray"));
	}

	/**
	 * addBeanItemValueTest3
	 */
	@Test
	public void addBeanItemValueTest3() {
		final JavaBean bean = new JavaBean();
		bean.setInteger(200);
		bean.setIntegerArray(new Integer[]{222, 888});

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.addBeanItemValue(um, bean, "Integer");
		ModelUtil.addBeanItemValue(um, bean, "IntegerArray");

		Assertions.assertTrue(um.containsKey("Integer"));
		Assertions.assertTrue(um.hasValue("Integer"));
		Assertions.assertEquals(Integer.valueOf(200), um.getNumber("Integer"));
		Assertions.assertEquals(1, um.getArraySize("Integer"));
		Assertions.assertEquals(1, um.getNumberArray("Integer").length);
		Assertions.assertFalse(um.isArrayValue("Integer"));

		Assertions.assertTrue(um.containsKey("IntegerArray"));
		Assertions.assertTrue(um.hasValue("IntegerArray"));
		Assertions.assertEquals(Integer.valueOf(222), um.getNumber("IntegerArray"));
		Assertions.assertEquals(2, um.getArraySize("IntegerArray"));
		Assertions.assertEquals(2, um.getNumberArray("IntegerArray").length);
		Assertions.assertTrue(um.isArrayValue("IntegerArray"));
	}


	/**
	 * setModelValueTest1
	 */
	@Test
	public void setModelValueTest1() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um);

		Assertions.assertEquals(0, bean.getPrimitiveInteger());
		Assertions.assertNull(bean.getPrimitiveIntegerArray());
		Assertions.assertNull(bean.getInteger());
		Assertions.assertNull(bean.getIntegerArray());
	}

	/**
	 * setModelValueTest2
	 */
	@Test
	public void setModelValueTest2() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", 100);
		um.setValue("PrimitiveIntegerArray", 222, 333);
		um.setValue("Integer", 444);
		um.setValue("IntegerArray", 555, 666);
		ModelUtil.setModelValue(bean, um);

		Assertions.assertEquals(100, bean.getPrimitiveInteger());
		Assertions.assertEquals(222, bean.getPrimitiveIntegerArray()[0]);
		Assertions.assertEquals(333, bean.getPrimitiveIntegerArray()[1]);
		Assertions.assertEquals(Integer.valueOf(444), bean.getInteger());
		Assertions.assertEquals(Integer.valueOf(555), bean.getIntegerArray()[0]);
		Assertions.assertEquals(Integer.valueOf(666), bean.getIntegerArray()[1]);
	}

	/**
	 * setModelValueTest3
	 */
	@Test
	public void setModelValueTest3() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", 100, 200);
		um.setValue("StringArray", 300, 400);
		ModelUtil.setModelValue(bean, um);

		Assertions.assertEquals("100", bean.getString());
		Assertions.assertEquals("300", bean.getStringArray()[0]);
		Assertions.assertEquals("400", bean.getStringArray()[1]);
	}

	/**
	 * setModelValueTest4
	 */
	@Test
	public void setModelValueTest4() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", 1000);
		um.setValue("StringArray", 300, 400);
		ModelUtil.setModelValue(bean, um);

		Assertions.assertEquals("1000", bean.getString());
		Assertions.assertEquals("300", bean.getStringArray()[0]);
		Assertions.assertEquals("400", bean.getStringArray()[1]);
	}


	/**
	 * setModelValueTest10
	 */
	@Test
	public void setModelValueTest10() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertEquals(0, bean.getPrimitiveInteger());
		Assertions.assertNull(bean.getPrimitiveIntegerArray());
		Assertions.assertNull(bean.getInteger());
		Assertions.assertNull(bean.getIntegerArray());
	}

	/**
	 * setModelValueTest11
	 */
	@Test
	public void setModelValueTest11() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("PrimitiveInteger", 111, 222);
		um.setValue("Integer", 333, 444);
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertEquals(222, bean.getPrimitiveInteger());
		Assertions.assertEquals(Integer.valueOf(444), bean.getInteger());
		Assertions.assertNull(bean.getPrimitiveIntegerArray());
		Assertions.assertNull(bean.getIntegerArray());
	}

	/**
	 * setModelValueTest12
	 */
	@Test
	public void setModelValueTest12() {
		final JavaBean bean = new JavaBean();

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", 111, 222);
		ModelUtil.setModelValue(bean, um, 1);

		Assertions.assertEquals("222", bean.getString());
		Assertions.assertNull(bean.getStringArray());
	}

	/**
	 * setModelValueTest31
	 */
	@Test
	public void setModelValueTest31() {
		final JavaBean bean = new JavaBean();
		bean.setString("String");
		bean.setStringArray("String");

		final UniModelImpl um = new UniModelImpl();
		um.setValue("String", 11, 22);
		um.setValue("StringArray", 33, 44);

		ModelUtil.setModelValue(bean, um, 2);

		Assertions.assertEquals("String", bean.getString());
		Assertions.assertNotNull(bean.getStringArray());
		Assertions.assertEquals(2, bean.getStringArray().length);
		Assertions.assertEquals("33", bean.getStringArray()[0]);
		Assertions.assertEquals("44", bean.getStringArray()[1]);
	}
}
