package com.sysdeo.eclipse.tomcat;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.core.runtime.IPath;

/**
 * Tomcat7Bootstrap
 *
 */
public class Tomcat7Bootstrap extends Tomcat6Bootstrap {

	/**
	 * Constructor
	 * @param xml isServerXmlMode
	 * @param cf TomcatConfigFile
	 * @param manager isSecurityManagerEnabled
	 * @param home TomcatClasspathVariable
	 */
	public Tomcat7Bootstrap(final boolean xml, final String cf, final boolean manager, final IPath home) {
		super(xml, cf, manager, home);
	}

	/**
	 * @see com.sysdeo.eclipse.tomcat.Tomcat6Bootstrap#getClasspath()
	 */
	@Override
	public String[] getClasspath() {
		ArrayList<String> classpath = new ArrayList<>();
		classpath.add(getTomcatDir() + File.separator + "bin" + File.separator + "bootstrap.jar");
		classpath.add(getTomcatDir() + File.separator + "bin" + File.separator + "tomcat-juli.jar");
		// Add tools.jar JDK file to classpath
		String toolsJarLocation = super.getVmInstalled().getInstallLocation()
						+ File.separator + "lib" + File.separator + "tools.jar";
		if (new File(toolsJarLocation).exists()) {
			classpath.add(toolsJarLocation);
		}
		return classpath.toArray(new String[classpath.size()]);
	}

	/**
	 * @see com.sysdeo.eclipse.tomcat.Tomcat6Bootstrap#getLabel()
	 */
	@Override
	public String getLabel() {
		return "Tomcat 7.x";
	}
}
