/*
 * (c) Copyright Martin Kahr, Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PropertyPage;

/**
 * provides a tab control with property pages for the
 * settings of a tomcat project.
 *
 * @version 	1.0
 * @author		Martin Kahr
 */
public class TomcatProjectPropertyPage extends PropertyPage implements IWorkbenchPreferencePage {

	/** TabFolder */
	private TabFolder folder;
	/** TomcatProjectGeneralPropertyPage */
	private TomcatProjectGeneralPropertyPage generalPropertyPage = null;
	/** TomcatProjectWebclasspathPropertyPage */
	private TomcatProjectWebclasspathPropertyPage webClassPathPropertyPage = null;
	/** TomcatProjectWARPropertyPage */
	private TomcatProjectWARPropertyPage warPropertyPage = null;

	/**
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected Control createContents(final Composite parent) {
		this.folder = new TabFolder(parent, SWT.NONE);
		this.folder.setLayoutData(new GridData(GridData.FILL_BOTH));

		try {
			// general property page
			this.generalPropertyPage = new TomcatProjectGeneralPropertyPage(getJavaProject(), getTomcatProject());
			// add to tab
			TabItem generalTab = new TabItem(this.folder, SWT.NONE);
			generalTab.setText(TomcatPluginResources.PROPERTIES_PAGE_PROJECT_GENERAL_TAB_LABEL);
			generalTab.setControl(this.generalPropertyPage.createContents(this.folder));

			// webclasspath property page
			this.webClassPathPropertyPage = new TomcatProjectWebclasspathPropertyPage(
					getJavaProject(), getTomcatProject());
			// add to tab
			TabItem webClassTab = new TabItem(this.folder, SWT.NONE);
			webClassTab.setText(TomcatPluginResources.PROPERTIES_PAGE_PROJECT_DEVLOADER_TAB_LABEL);
			webClassTab.setControl(this.webClassPathPropertyPage.getControl(this.folder));

			// war property page
			this.warPropertyPage = new TomcatProjectWARPropertyPage(getTomcatProject(), getShell());
		} catch (final CoreException ex) {
			TomcatLauncherPlugin.log(ex);
		}
		// add to tab
		TabItem warTab = new TabItem(this.folder, SWT.NONE);
		warTab.setText(TomcatPluginResources.PROPERTIES_PAGE_PROJECT_WAR_TAB_LABEL);
		warTab.setControl(this.warPropertyPage.createContents(this.folder));

		return this.folder;
	}

	/**
	 * @see org.eclipse.jface.preference.PreferencePage#performOk()
	 */
	@Override
	public boolean performOk() {
		// delegate to property pages
		if (this.generalPropertyPage.performOk()) {
			// check if it's a tomcat project any more
			if (this.generalPropertyPage.isTomcatProjectChecked()) {
				if (this.webClassPathPropertyPage.performOk()) {
					try {
						getTomcatProject().updateContext();
					} catch (final CoreException ex) {
						TomcatLauncherPlugin.log(ex);
					}
				}
				this.warPropertyPage.performOk();
			}
		}
		return true;
	}

	/**
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(IWorkbench)
	 */
	@Override
	public void init(final IWorkbench workbench) {
		return;
	}

	/**
	 * helper methods
	 * @return IJavaProject
	 * @throws CoreException CoreException
	 */
	protected IJavaProject getJavaProject() throws CoreException {
		IProject project = getElement().getAdapter(IProject.class);
		IProjectNature nature = project.getNature(JavaCore.NATURE_ID);
		if (!IJavaProject.class.isInstance(nature)) {
			throw new CoreException(new Status(IStatus.ERROR,
					TomcatLauncherPlugin.getDefault().getBundle().getSymbolicName(),
					nature + " is not IProjectNature."));
		}
		return (IJavaProject) nature;
	}

	/**
	 *
	 * @return TomcatProject
	 * @throws CoreException CoreException
	 */
	protected TomcatProject getTomcatProject() throws CoreException {
		return TomcatProject.create(getJavaProject());
	}
}
