/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat.actions;

import org.eclipse.core.runtime.CoreException;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatProject;

/**
 * RemoveTomcatContextActionDelegate
 *
 */
public class RemoveTomcatContextActionDelegate extends TomcatProjectAbstractActionDelegate {

	/**
	 * @see com.sysdeo.eclipse.tomcat.actions.TomcatProjectAbstractActionDelegate
	 * #doActionOn(com.sysdeo.eclipse.tomcat.TomcatProject)
	 */
	@Override
	public void doActionOn(final TomcatProject prj) throws CoreException {

		if (prj.getUpdateXml()) {
			prj.removeContext();
		} else {
			throw new TomcatActionException(
					TomcatLauncherPlugin.getResourceString("msg.action.updateServerXML.failed"));
		}
	}
}
