/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat.editors;

import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_ADDDIRBUTTON_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_ADDJARZIPBUTTON_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_DOWNBUTTON_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_REMOVEBUTTON_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.PREF_PAGE_UPBUTTON_LABEL;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Widget;

/**
 * Use in TomcatPreferencePage
 * This class is based on PathEditor
 * There is a button to add files on the list,
 * A field editor to edit directory paths.
 */
public class ClasspathFieldEditor extends ListFieldEditor {

	/** addJarZipButton */
	private Button addJarZipButton;
	/** addDirButton */
	private Button addDirButton;

	/**
	 * The last path, or <code>null</code> if none.
	 */
	private String lastPath;

	/**
	 * Creates a new path field editor
	 */
	protected ClasspathFieldEditor() {
		super();
	}

	/**
	 * Constructor
	 * @param name String
	 * @param labelText String
	 * @param parent Composite
	 */
	public ClasspathFieldEditor(final String name, final String labelText, final Composite parent) {
		init(name, labelText);
		createControl(parent);
	}

	/**
	 * @return String[]
	 */
	protected String[] getNewJarZip() {
		FileDialog dialog = new FileDialog(this.addJarZipButton.getShell(), SWT.MULTI);
		if (this.lastPath != null) {
			if (new File(this.lastPath).exists()) {
				dialog.setFilterPath(this.lastPath);
			}
		}

		dialog.open();

		String[] result = dialog.getFileNames();
		if (result.length != 0) {
			this.lastPath = dialog.getFilterPath();
			for (int i = 0; i < result.length; i++) {
				result[i] = this.lastPath + File.separator + result[i];
			}
			return result;
		}
		return new String[0];
	}

	/**
	 * @return NewDir
	 */
	protected String getNewDir() {
		DirectoryDialog dialog = new DirectoryDialog(this.addDirButton.getShell());
		if (this.lastPath != null) {
			if (new File(this.lastPath).exists()) {
				dialog.setFilterPath(this.lastPath);
			}
		}

		String dir = dialog.open();
		if (dir != null) {
			dir = dir.trim();
			if (dir.isEmpty()) {
				return null;
			}
			this.lastPath = dir;
		}
		return dir;
	}

	/**
	 * @see com.sysdeo.eclipse.tomcat.editors.ListFieldEditor#createButtons(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected void createButtons(final Composite buttonBox) {
		this.addJarZipButton = createPushButton(buttonBox, PREF_PAGE_ADDJARZIPBUTTON_LABEL);
		this.addDirButton = createPushButton(buttonBox, PREF_PAGE_ADDDIRBUTTON_LABEL);
		super.setRemoveButton(createPushButton(buttonBox, PREF_PAGE_REMOVEBUTTON_LABEL));
		super.setUpButton(createPushButton(buttonBox, PREF_PAGE_UPBUTTON_LABEL));
		super.setDownButton(createPushButton(buttonBox, PREF_PAGE_DOWNBUTTON_LABEL));
	}

	/**
	 * @see com.sysdeo.eclipse.tomcat.editors.ListFieldEditor#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	@Override
	public void widgetSelected(final SelectionEvent event) {
		Widget widget = event.widget;
		if (widget == this.addJarZipButton) {
			addJarZipPressed();
		} else if (widget == this.addDirButton) {
			addDirPressed();
		} else if (widget == super.getRemoveButton()) {
			super.removePressed();
		} else if (widget == super.getUpButton()) {
			super.upPressed();
		} else if (widget == super.getDownButton()) {
			super.downPressed();
		} else if (widget == super.getList()) {
			super.selectionChanged();
		}
	}

	/**
	 * addJarZipPressed
	 */
	protected void addJarZipPressed() {
		setPresentsDefaultValue(false);

		for (final String input : getNewJarZip()) {
			int index = super.getList().getSelectionIndex();
			if (index >= 0) {
				super.getList().add(input, index + 1);
			} else {
				super.getList().add(input, 0);
			}
			selectionChanged();
		}
	}

	/**
	 * addDirPressed
	 */
	protected void addDirPressed() {
		setPresentsDefaultValue(false);
		String input = getNewDir();

		if (input != null) {
			int index = super.getList().getSelectionIndex();
			if (index >= 0) {
				super.getList().add(input, index + 1);
			} else {
				super.getList().add(input, 0);
			}
			selectionChanged();
		}
	}
}
