/*
 * Copyright 2004-2014 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.extension.dbcp.impl;

import javax.sql.XAConnection;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * @author higa
 *
 */
public class XAConnectionImplTest {

    /** target */
    private XADataSourceImpl xads2 = null;

    /**
     * setUp
     */
    @Before
    public void setUp() {
        this.xads2 = new XADataSourceImpl();
        this.xads2.setDriverClassName("org.postgresql.Driver");
        this.xads2.setURL("jdbc:postgresql://localhost:5432/test");
        this.xads2.setUser("postgres");
        this.xads2.setPassword("postgres");
    }

    /**
     * @throws Exception Exception
     */
    @Test
    public void testGetConnectionAndGetXAResource() throws Exception {
        XAConnection xaCon = null;
        try {
            xaCon = this.xads2.getXAConnection();
            Assert.assertNotNull("1", xaCon.getConnection());
            Assert.assertNotNull("2", xaCon.getXAResource());
        } finally {
            if (xaCon != null) {
                xaCon.close();
            }
        }
    }
}
