package online.filter.develop;

import java.util.stream.Stream;

import org.seasar.framework.container.hotdeploy.HotdeployClassLoader;

/**
 * HotDeployClassLoader
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class S2HotDeployClassLoader extends HotdeployClassLoader {

    /** 対象パッケージ */
    private final String[] inc;
    /** 対象外パッケージ */
    private final String[] exc;

    /**
     * コンストラクタ
     *
     * @param cl 親クラスローダ
     * @param incl 対象配列
     * @param excl 対象外配列
     */
    public S2HotDeployClassLoader(final ClassLoader cl, final String[] incl, final String[] excl) {
        super(cl);
        this.inc = (incl != null) ? incl.clone() : new String[0];
        this.exc = (excl != null) ? excl.clone() : new String[0];
    }

    /**
     * リクエスト時読込対象クラス判断
     *
     * @return 対象クラスの場合 true を返す。
     */
    @Override
    protected boolean isTargetClass(final String className) {
        return starts(className, this.inc) && !starts(className, this.exc);
    }

    /**
     * 特定文字列で開始判断
     * @param name 判断対象
     * @param array 特定文字列配列
     * @return 開始している場合 true を返す。
     */
    private boolean starts(final String name, final String... array) {
        return Stream.of(array).anyMatch(name::startsWith);
    }
}
