package common.db;

/**
 * 排他例外
 *
 * @author Tadashi Nakayama
 */
public class ExclusiveException extends RuntimeException {
	/** serialVersionUID */
	private static final long serialVersionUID = 1L;

	/** NO WAITフラグ */
	private final boolean noWait;

	/**
	 * コンストラクタ
	 *
	 * @param message 詳細内容
	 */
	public ExclusiveException(final String message) {
		this(message, false);
	}

	/**
	 * コンストラクタ
	 *
	 * @param cause 原因例外
	 */
	public ExclusiveException(final Throwable cause) {
		this(cause, false);
	}

	/**
	 * コンストラクタ
	 *
	 * @param message 詳細内容
	 * @param nw NO WAIT フラグ
	 */
	public ExclusiveException(final String message, final boolean nw) {
		super(message);
		this.noWait = nw;
	}

	/**
	 * コンストラクタ
	 *
	 * @param cause 原因例外
	 * @param nw NO WAIT フラグ
	 */
	public ExclusiveException(final Throwable cause, final boolean nw) {
		super(cause.getMessage(), cause);
		this.noWait = nw;
	}

	/**
	 * NO WAIT判断
	 *
	 * @return NO WAIT の場合 true を返す。
	 */
	public boolean isNoWait() {
		return this.noWait;
	}
}
