/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.StringUtil;

public class S2ContainerUtil
implements ContainerConstants {
    private static final Logger logger = Logger.getLogger(S2ContainerUtil.class);
    private static Set notAssignableClasses = new HashSet();
    static /* synthetic */ Class class$java$lang$Object;

    private S2ContainerUtil() {
    }

    public static Class[] getAssignableClasses(Class componentClass) {
        HashSet classes = new HashSet();
        for (Class clazz = componentClass; clazz != (class$java$lang$Object == null ? S2ContainerUtil.class$("java.lang.Object") : class$java$lang$Object) && clazz != null; clazz = clazz.getSuperclass()) {
            S2ContainerUtil.addAssignableClasses(classes, clazz);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static void addAssignableClasses(Set classes, Class clazz) {
        if (notAssignableClasses.contains(clazz)) {
            return;
        }
        classes.add(clazz);
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            S2ContainerUtil.addAssignableClasses(classes, interfaces[i]);
        }
    }

    public static void putRegisterLog(ComponentDef cd) {
        if (logger.isDebugEnabled()) {
            String componentName;
            StringBuffer buf = new StringBuffer(100);
            Class componentClass = cd.getComponentClass();
            if (componentClass != null) {
                buf.append(componentClass.getName());
            }
            if (!StringUtil.isEmpty(componentName = cd.getComponentName())) {
                buf.append("[").append(componentName).append("]");
            }
            logger.log("DSSR0105", new Object[]{new String(buf)});
        }
    }

    static {
        notAssignableClasses.add(Cloneable.class);
        notAssignableClasses.add(Comparable.class);
        notAssignableClasses.add(Serializable.class);
        notAssignableClasses.add(Externalizable.class);
        notAssignableClasses.add(ContainerConstants.class);
    }
}

