/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.chain2.config;

/**
 * Runtime exception representing an exception that occurred during a
 * configuration phase within a chain component.
 *
 * @version $Id$
 */
public class ChainConfigurationException extends RuntimeException {
    /** serialVersionUID */
    private static final long serialVersionUID = -1829912248939018106L;

    /**
     * constructor
     */
    public ChainConfigurationException() {
        super();
    }

    /**
     * @param message String
     */
    public ChainConfigurationException(final String message) {
        super(message);
    }

    /**
     * @param message String
     * @param cause Throwable
     */
    public ChainConfigurationException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * @param cause Throwable
     */
    public ChainConfigurationException(final Throwable cause) {
        super(cause);
    }

}
