/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.chain2.testutils;

import static org.apache.commons.chain2.testutils.HasLog.hasLog;

import java.util.UUID;

import org.apache.commons.chain2.Context;
import org.apache.commons.chain2.Processing;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 * @version $Id$
 */
public class NonDelegatingCommandTestCase {

    private static final String ID = UUID.randomUUID().toString();

    private NonDelegatingCommand command = null;
    private Context<String, Object> context = null;

    /**
     * Setup
     */
    @Before
    public void setUp() {
        this.command = new NonDelegatingCommand(ID);
        this.context = new TestContext<>();
    }

    /**
     * executeNullThrowsException
     */
    @Test(expected = IllegalArgumentException.class)
    public void executeNullThrowsException() {
        this.command.execute(null);
    }

    /**
     * createsLogInEmptyContext
     */
    @Test
    public void createsLogInEmptyContext() {
        execute();

        Assert.assertEquals(1, this.context.size());
        Assert.assertTrue(this.context.containsKey("log"));
        Assert.assertThat(this.context, hasLog(ID));
    }

    /**
     * existingLogIsReused
     */
    @Test
    public void existingLogIsReused() {
        this.context.put("log", new StringBuilder("some content"));
        execute();

        Assert.assertThat(this.context, hasLog("some content/" + ID));
    }

    private void execute() {
        Assert.assertEquals(Processing.FINISHED, this.command.execute(this.context));
    }
}
