package org.apache.commons.chain2.testutils;

import java.util.HashMap;

import org.apache.commons.chain2.Context;
import org.apache.commons.chain2.config.ConfigUtil;

/**
 * Since we can not import classes from modules that depend on test utils (eg chain2-base)
 * we have to implement a test context here.
 *
 * @version $Id$
 * @param <K> K
 * @param <V> V
 */
public class TestContext<K, V> extends HashMap<K, V> implements Context<K, V> {

    /** serialVersionUID */
    private static final long serialVersionUID = 1215416563835249179L;

    /**
     * @see org.apache.commons.chain2.Context#retrieve(java.lang.Object)
     */
    @Override
    public <T extends V> T retrieve(final K key) {
        return ConfigUtil.cast(get(key));
    }
}
