package common.db;


/**
 * 排他例外クラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class ExclusiveException extends RuntimeException {
	/** serialVersionUID */
	private static final long serialVersionUID = -5672869739245079334L;

	/** NO WAITフラグ */
	private final boolean noWait;

	/**
	 * コンストラクタ
	 *
	 * @param message 詳細内容
	 */
	public ExclusiveException(final String message) {
		this(message, false);
	}

	/**
	 * コンストラクタ
	 *
	 * @param cause 原因例外
	 */
	public ExclusiveException(final Throwable cause) {
		this(cause, false);
	}

	/**
	 * コンストラクタ
	 *
	 * @param message 詳細内容
	 * @param nw NO WAIT フラグ
	 */
	public ExclusiveException(final String message, final boolean nw) {
		super(message);
		this.noWait = nw;
	}

	/**
	 * コンストラクタ
	 *
	 * @param cause 原因例外
	 * @param nw NO WAIT フラグ
	 */
	public ExclusiveException(final Throwable cause, final boolean nw) {
		super(cause.getMessage(), cause);
		this.noWait = nw;
	}

	/**
	 * NO WAIT判断
	 * @return NO WAIT の場合 true を返す。
	 */
	public final boolean isNoWait() {
		return this.noWait;
	}
}
