package common.sql;

import java.util.List;
import java.util.Map;

/**
 * パース通常文字列保持クラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
final class LineParsedNodeString implements LineParsedNode {
	/** クエリ */
	private final String query;

	/**
	 * コンストラクタ
	 *
	 * @param val クエリ
	 */
	LineParsedNodeString(final String val) {
		this.query = val;
	}

	/**
	 * クエリ構築
	 *
	 * @param pmap パラメタマップ
	 * @param plist パラメタリスト
	 * @return クエリ
	 */
	@Override
	public String build(final Map<String, ?> pmap, final List<Object> plist) {
		return this.query;
	}

	/**
	 * ターゲット判断
	 *
	 * @param pmap パラメタマップ
	 * @return ターゲットの場合 true を返す。
	 */
	@Override
	public boolean isTarget(final Map<String, ?> pmap) {
		return true;
	}
}
