package batch.base;

import java.sql.Timestamp;


/**
 * バッチパラメタインタフェース
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public interface BatchParameter {
	/** バッチ起動時オプション */
	String ID_B_ONLINE_OPTION = "-o";
	/** バッチ起動時プロセスIDオプション */
	String ID_B_PID_OPTION = "-p";
	/** バッチ起動ユーザオプション */
	String ID_B_USER_ID = "-u";

	/**
	 * ジョブ番号取得
	 *
	 * @return ジョブ番号
	 */
	long getJobSeq();

	/**
	 * ジョブ詳細番号取得
	 *
	 * @return ジョブ詳細番号
	 */
	int getJobDtlSeq();

	/**
	 * IPアドレス取得
	 *
	 * @return IPアドレス
	 */
	String getIp();

	/**
	 * プロセスID取得
	 *
	 * @return プロセスID
	 */
	int getPid();

	/**
	 * ユーザID取得
	 *
	 * @return ユーザID
	 */
	String getUid();

	/**
	 * ジョブ名取得
	 *
	 * @return ジョブ名
	 */
	String getJobName();

	/**
	 * 処理開始日時設定
	 *
	 * @param val 処理開始日時
	 */
	void setDateTime(Timestamp val);

	/**
	 * 処理開始日時取得
	 *
	 * @return 処理開始日時
	 */
	Timestamp getDateTime();

	/**
	 * オンライン引数設定
	 *
	 * @param name バッチ名
	 * @param datetime 開始日時
	 * @return 設定正常終了の場合 true を返す。
	 */
	boolean setupOnline(String name, Timestamp datetime);

	/**
	 * コマンドライン引数設定
	 *
	 * @param args 引数
	 */
	void setCommandParameter(String... args);

	/**
	 * パラメタ取得
	 *
	 * @return 処理後引数
	 */
	String[] getParameter();
}
