package batch.status;

/**
 * ジョブファイル管理
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public class JobFile {
	/** identifier field */
	private volatile long jobSeq;

	/** identifier field */
	private int batSeq;

	/** identifier field */
	private int fileSeq;

	/** nullable persistent field */
	private String fileName;

	/** nullable persistent field */
	private String pathName;

	/** nullable persistent field */
	private volatile long fileSize;

	/** nullable persistent field */
	private String downloadName;

	/** nullable persistent field */
	private int downloadCount;

	/**
	 * バッチ連番取得
	 *
	 * @return バッチ連番
	 */
	public final int getBatSeq() {
		return this.batSeq;
	}

	/**
	 * バッチ連番設定
	 *
	 * @param val バッチ連番
	 */
	public final void setBatSeq(final int val) {
		this.batSeq = val;
	}

	/**
	 * ダウンロード回数取得
	 *
	 * @return ダウンロード回数
	 */
	public final int getDownloadCount() {
		return this.downloadCount;
	}

	/**
	 * ダウンロード回数設定
	 *
	 * @param val ダウンロード回数
	 */
	public final void setDownloadCount(final int val) {
		this.downloadCount = val;
	}

	/**
	 * ダウンロード名取得
	 *
	 * @return ダウンロード名
	 */
	public final String getDownloadName() {
		return this.downloadName;
	}

	/**
	 * ダウンロード名設定
	 *
	 * @param val ダウンロード名
	 */
	public final void setDownloadName(final String val) {
		this.downloadName = val;
	}

	/**
	 * ファイル名取得
	 *
	 * @return ファイル名
	 */
	public final String getFileName() {
		return this.fileName;
	}

	/**
	 * ファイル名設定
	 *
	 * @param val ファイル名
	 */
	public final void setFileName(final String val) {
		this.fileName = val;
	}

	/**
	 * ファイル連番取得
	 *
	 * @return ファイル連番
	 */
	public final int getFileSeq() {
		return this.fileSeq;
	}

	/**
	 * ファイル連番設定
	 *
	 * @param val ファイル連番
	 */
	public final void setFileSeq(final int val) {
		this.fileSeq = val;
	}

	/**
	 * ファイルサイズ取得
	 *
	 * @return ファイルサイズ
	 */
	public final long getFileSize() {
		return this.fileSize;
	}

	/**
	 * ファイルサイズ設定
	 *
	 * @param val ファイルサイズ
	 */
	public final void setFileSize(final long val) {
		this.fileSize = val;
	}

	/**
	 * ジョブ連番取得
	 *
	 * @return ジョブ連番
	 */
	public final long getJobSeq() {
		return this.jobSeq;
	}

	/**
	 * ジョブ連番設定
	 *
	 * @param val ジョブ連番
	 */
	public final void setJobSeq(final long val) {
		this.jobSeq = val;
	}

	/**
	 * パス名取得
	 *
	 * @return パス名
	 */
	public final String getPathName() {
		return this.pathName;
	}

	/**
	 * パス名設定
	 *
	 * @param val パス名
	 */
	public final void setPathName(final String val) {
		this.pathName = val;
	}
}
