package online.filter.helper;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/**
 * レスポンスラッパクラス
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class DuplicateHeaderWrapper extends HttpServletResponseWrapper {
	/** レスポンスオブジェクト複製クラス */
	private final DuplicateHeaderResponse dhr = new DuplicateHeaderResponse();

	/**
	 * コンストラクタ
	 *
	 * @param response HttpServletResponseオブジェクト
	 */
	public DuplicateHeaderWrapper(final HttpServletResponse response) {
		super(response);
	}

	/**
	 * HttpServletResponse取得
	 * @return HttpServletResponse
	 */
	public HttpServletResponse getHttpResponse() {
		return HttpServletResponse.class.cast(super.getResponse());
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper
	 * #addCookie(javax.servlet.http.Cookie)
	 */
	@Override
	public void addCookie(final Cookie cookie) {
		super.addCookie(cookie);
		this.dhr.addCookie(cookie);
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper
	 * #addDateHeader(java.lang.String, long)
	 */
	@Override
	public void addDateHeader(final String name, final long date) {
		super.addDateHeader(name, date);
		this.dhr.addDateHeader(name, Long.valueOf(date));
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper
	 * #addHeader(java.lang.String, java.lang.String)
	 */
	@Override
	public void addHeader(final String name, final String value) {
		super.addHeader(name, value);
		this.dhr.addHeader(name, value);
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper
	 * #addIntHeader(java.lang.String, int)
	 */
	@Override
	public void addIntHeader(final String name, final int value) {
		super.addIntHeader(name, value);
		this.dhr.addIntHeader(name, Integer.valueOf(value));
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper
	 * #containsHeader(java.lang.String)
	 */
	@Override
	public boolean containsHeader(final String name) {
		return this.dhr.containsHeader(name);
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper
	 * #sendError(int)
	 */
	@Override
	public void sendError(final int sc) throws IOException {
		super.sendError(sc);
		this.dhr.sendError(Integer.valueOf(sc));
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper
	 * #sendError(int, java.lang.String)
	 */
	@Override
	public void sendError(final int sc, final String msg) throws IOException {
		super.sendError(sc, msg);
		this.dhr.sendError(Integer.valueOf(sc), msg);
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper
	 * #sendRedirect(java.lang.String)
	 */
	@Override
	public void sendRedirect(final String location) throws IOException {
		super.sendRedirect(location);
		this.dhr.sendRedirect(location);
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper
	 * #setDateHeader(java.lang.String, long)
	 */
	@Override
	public void setDateHeader(final String name, final long date) {
		super.setDateHeader(name, date);
		this.dhr.setDateHeader(name, Long.valueOf(date));
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper
	 * #setHeader(java.lang.String, java.lang.String)
	 */
	@Override
	public void setHeader(final String name, final String value) {
		super.setHeader(name, value);
		this.dhr.setHeader(name, value);
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper
	 * #setIntHeader(java.lang.String, int)
	 */
	@Override
	public void setIntHeader(final String name, final int value) {
		super.setIntHeader(name, value);
		this.dhr.setIntHeader(name, Integer.valueOf(value));
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper#getHeader(java.lang.String)
	 */
	@Override
	public String getHeader(final String name) {
		return this.dhr.getHeader(name);
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper#getHeaders(java.lang.String)
	 */
	@Override
	public Collection<String> getHeaders(final String name) {
		return this.dhr.getHeaders(name);
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper#getHeaderNames()
	 */
	@Override
	public Collection<String> getHeaderNames() {
		return this.dhr.getHeaderNames();
	}

	/**
	 * @see javax.servlet.http.HttpServletResponseWrapper#setStatus(int)
	 */
	@Override
	public void setStatus(final int sc) {
		super.setStatus(sc);
		this.dhr.setStatus(Integer.valueOf(sc));
	}

	/**
	 * ステータス取得
	 * @return ステータス
	 */
	@Override
	public int getStatus() {
		return this.dhr.getStatus();
	}

	/**
	 * @see javax.servlet.ServletResponse#setBufferSize(int)
	 */
	@Override
	public void setBufferSize(final int size) {
		super.setBufferSize(size);
		this.dhr.setBufferSize(Integer.valueOf(size));
	}

	/**
	 * @see javax.servlet.ServletResponse#getBufferSize()
	 */
	@Override
	public int getBufferSize() {
		return this.dhr.getBufferSize();
	}

	/**
	 * @see javax.servlet.ServletResponse
	 * #setCharacterEncoding(java.lang.String)
	 */
	@Override
	public void setCharacterEncoding(final String charset) {
		super.setCharacterEncoding(charset);
		this.dhr.setCharacterEncoding(charset);
	}

	/**
	 * @see javax.servlet.ServletResponse#getCharacterEncoding()
	 */
	@Override
	public String getCharacterEncoding() {
		return this.dhr.getCharacterEncoding();
	}

	/**
	 * @see javax.servlet.ServletResponse#setContentLength(int)
	 */
	@Override
	public void setContentLength(final int len) {
		super.setContentLength(len);
		this.dhr.setContentLength(Integer.valueOf(len));
	}

	/**
	 * @see javax.servlet.ServletResponse#setContentType(java.lang.String)
	 */
	@Override
	public void setContentType(final String type) {
		super.setContentType(type);
		this.dhr.setContentType(type);
	}

	/**
	 * @see javax.servlet.ServletResponse#getContentType()
	 */
	@Override
	public String getContentType() {
		return this.dhr.getContentType();
	}

	/**
	 * @see javax.servlet.ServletResponse#setLocale(java.util.Locale)
	 */
	@Override
	public void setLocale(final Locale loc) {
		super.setLocale(loc);
		this.dhr.setLocale(loc);
	}

	/**
	 * @see javax.servlet.ServletResponse#getLocale()
	 */
	@Override
	public Locale getLocale() {
		return this.dhr.getLocale();
	}

	/**
	 * @see javax.servlet.ServletResponse#reset()
	 */
	@Override
	public void reset() {
		super.reset();
		this.dhr.reset();
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return this.dhr.toString();
	}

	/**
	 * 複製情報取得
	 *
	 * @return レスポンス複製クラス
	 */
	public DuplicateHeaderResponse getDuplicateHeaderResponse() {
		return this.dhr;
	}
}
