package project.check.existence;

import java.util.Objects;
import java.util.Optional;

import core.util.ArrayUtil;
import core.util.bean.Pair;
import online.model.ModelUtil;
import project.check.BaseCheck;

/**
 * 選択項目配列内妥当性チェック
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class ElementCheck extends BaseCheck {

	/** 項目チェック対象配列 */
	private final String[] array;
	/** メッセージID */
	private final String mid;
	/** メッセージパラメータ */
	private final String[] prm;

	/**
	 * コンストラクタ
	 * @param s 項目チェック対象配列
	 */
	public ElementCheck(final String[] s) {
		this.array = ArrayUtil.copyOf(s);
		this.mid = null;
		this.prm = null;
	}

	/**
	 * コンストラクタ
	 *
	 * @param s 項目チェック対象配列
	 * @param msgId メッセージID
	 * @param param メッセージパラメータ
	 */
	public ElementCheck(final String[] s, final String msgId, final String... param) {
		this.array = ArrayUtil.copyOf(s);
		this.mid = msgId;
		this.prm = ArrayUtil.copyOf(param);
	}

	/**
	 * @see online.context.check.ItemCheck#check(java.lang.String...)
	 */
	@Override
	public void check(final String... items) {
		Optional<Pair<String, Integer>> check = Optional.empty();
		for (final String item : items) {
			String[] val = super.getArrayParameter(item);
			for (int j = 0; val != null && j < val.length; j++) {
				if (!super.isTarget(j)) {
					val[j] = ModelUtil.getValueAsString(super.getUniModel(), item, j);
				} else if (Objects.toString(val[j], "").isEmpty()) {
					continue;
				} else if (!compare(val[j])) {
					super.setMessage(item, j, this.mid, this.prm);
					check = Optional.of(check.orElse(new Pair<>(item, Integer.valueOf(j))));
				}
			}
		}

		check.ifPresent(this::throwKeepCheckException);
	}

	/**
	 * 配列内存在チェック
	 *
	 * @param val チェック値
	 * @return 配列内に存在する場合 true を返す。
	 */
	private boolean compare(final String val) {
		for (int i = 0; this.array != null && i < this.array.length; i++) {
			if (this.array[i].equals(val)) {
				return true;
			}
		}
		return false;
	}
}
