package online.struts.filter;

import java.util.Objects;
import java.util.regex.Pattern;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

import online.context.session.SessionAttributeUtil;
import online.filter.ActionCountFilter;
import online.filter.FilterUtil;
import online.filter.SessionAttributeFilter;
import online.struts.mapping.RequestMapping;

/**
 * セション抽出・保存フィルタ
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class SessionFilter extends SessionAttributeFilter {

	/** 数字のみパターン */
	private static final Pattern PATTERN = Pattern.compile("^[0-9]+$");

	/**
	 * アクションセションキー取得
	 *
	 * @param context サーブレットコンテキスト
	 * @param request サーブレットリクエスト
	 * @return アクションセションキー
	 */
	@Override
	protected String getActionSessionKey(
					final ServletContext context, final HttpServletRequest request) {
		RequestMapping rm = RequestMapping.findRequestMapping(context, request);
		if (rm != null) {
			// SIDパラメタ取得
			if (rm.getKeepId() == null || !rm.isMultipleKeep()) {
				return rm.getKeepId();
			}

			String key = RequestMapping.dropLineTerminators(
					SessionAttributeUtil.getParameterSid(request));
			if (isNumeric(key) && super.hasSession(key, request)) {
				return key;
			} else if (FilterUtil.isGetMethod(request.getMethod())) {
				return Objects.toString(ActionCountFilter.getActionCount(request), null);
			}
		}
		return null;
	}

	/**
	 * @see online.filter.SessionAttributeFilter
	 * #isMultiple(javax.servlet.ServletContext, javax.servlet.http.HttpServletRequest)
	 */
	@Override
	protected boolean isMultiple(
					final ServletContext context, final HttpServletRequest request) {
		RequestMapping rm = RequestMapping.findRequestMapping(context, request);
		return rm != null && rm.getKeepId() != null && rm.isMultipleKeep();
	}

	/**
	 * 数字判断
	 * @param val 文字列
	 * @return 数字の場合 true を返す。
	 */
	private boolean isNumeric(final String val) {
		return val != null && PATTERN.matcher(val).matches();
	}
}
