package project.web.generic.csv;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;

import online.context.check.InputCheck;
import online.model.ModelUtil;
import online.model.UniModel;
import online.model.UniModelImpl;
import online.struts.action.BaseAction;
import online.struts.action.UniForm;

import org.apache.struts.upload.FormFile;

import project.base.upload.ImportAbstract;
import project.check.attribute.LongNumeralCheck;
import project.check.attribute.NumberCheck;
import project.check.existence.MustCheck;
import project.master.MsgUtil;
import project.web.InstanceFactory;
import batch.util.ParameterUtil;
import core.config.Factory;

/**
 * CSV取込アクション
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class ImportAction extends BaseAction {

	/** キー項目 */
	private static final String ID = "Id";
	/** ファイル名綱目 */
	private static final String IMPORT_FILE = "ImportFile";
	/** 総件数 */
	private static final String TOTAL_COUNT = "TotalCount";
	/** 処理件数 */
	private static final String UPLOAD_COUNT = "UploadCount";
	/** 無視行 */
	private static final String IGNORE = "Ignore";
	/** エラー行 */
	private static final String ERROR = "Error";

	/**
	 * 初期表示
	 * @param model 汎用モデル
	 * @return 処理結果
	 */
	public String get(final UniForm model) {
		InputCheck ic = InstanceFactory.create(InputCheck.class, model);
		ic.add(ID, new LongNumeralCheck());
		ic.populate();

		if (!CsvActionUtil.select("project.base.upload.SelectUpload", model)) {
			if (!MsgUtil.hasTopMessage(model)) {
				if (model.hasQueryString()) {
					return ID_NG_REDIRECT;
				}
			}
		}

		return ID_VIEW;
	}

	/**
	 * アップロード
	 * @param model 汎用モデル
	 * @return 処理結果
	 */
	public String upload(final UniForm model) {
		InputCheck ic = InstanceFactory.create(InputCheck.class, model);
		ic.add(ID, new MustCheck(), new LongNumeralCheck());
		ic.add(IMPORT_FILE, new MustCheck());
		ic.populate();

		if (!CsvActionUtil.select("project.base.upload.SelectUpload", model)) {
			return ID_NG_REDIRECT;
		}

		ImportAbstract sa = InstanceFactory.create(getServiceClass(model), model);
		setParameter(sa, model);
		if (sa.check()) {
			if (sa.getCount() == 0) {
				MsgUtil.putTopMessage(model, "ZZ000000013");
			} else {
				MsgUtil.putTopMessage(model, "ZZ000000020");
			}
		} else {
			model.putAll(ModelUtil.getUniModel(sa));
		}
		model.setValue(TOTAL_COUNT, Integer.valueOf(sa.getCount()));

		return ID_VIEW;
	}

	/**
	 * インポート
	 * @param model 汎用モデル
	 * @return 処理結果
	 */
	public String insert(final UniForm model) {
		InputCheck ic = InstanceFactory.create(InputCheck.class, model);
		ic.add(ID, new MustCheck(), new LongNumeralCheck());
		ic.add(IMPORT_FILE, new MustCheck());
		ic.add(IGNORE, new NumberCheck());
		ic.add(ERROR, new NumberCheck());
		ic.populate();

		if (!CsvActionUtil.select("project.base.upload.SelectUpload", model)) {
			return ID_NG_REDIRECT;
		}

		insertFile(model);

		CsvActionUtil.update("project.base.upload.InsertUpload", model);

		return ID_OK;
	}

	/**
	 * 更新処理
	 * @param model 汎用モデル
	 */
	private void insertFile(final UniForm model) {
		ImportAbstract sa = InstanceFactory.create(getServiceClass(model), model);
		setParameter(sa, model);
		model.setValue(UPLOAD_COUNT, Integer.valueOf(sa.insert()));
		model.setValue(TOTAL_COUNT, Integer.valueOf(sa.getCount()));
	}

	/**
	 * View用処理
	 * @param model 汎用モデル
	 */
	public void view(final UniForm model) {
		CsvActionUtil.select("project.base.upload.SelectList", model);
	}

	/**
	 * クエリクラス取得
	 * @param <T> Type
	 * @param model 汎用モデル
	 * @return クエリクラス
	 */
	private <T extends ImportAbstract> Class<T> getServiceClass(final UniForm model) {
		Class<T> ret = Factory.loadClass(model.getString("Class"));
		if (ret == null) {
			ret = Factory.loadClass(model.getString("ImportClass"));
		}
		return ret;
	}

	/**
	 * パラメタ設定
	 * @param sa インポートサービス
	 * @param model 汎用モデル
	 */
	private void setParameter(final ImportAbstract sa, final UniForm model) {
		ModelUtil.setModelValue(sa, getParameterModel(model));
		ModelUtil.setUniModel(sa, model);

		try {
			List<FormFile> ff = model.getFormFile(IMPORT_FILE);
			if (!ff.isEmpty()) {
				// TODO:複数ファイル
				sa.setInputStream(ff.get(0).getInputStream());
			}
		} catch (final IOException ex) {
			throw new UncheckedIOException(ex);
		}
	}

	/**
	 * パラメタモデル取得
	 * @param model 汎用モデル
	 * @return パラメタモデル
	 */
	private UniModel getParameterModel(final UniModel model) {
		UniModel um = new UniModelImpl();
		ParameterUtil.toMap(ParameterUtil.toArray(model.getString("Param"))).forEach(um::setValue);
		return um;
	}
}
