package project.web.generic.master;

import online.context.check.InputCheck;
import online.struts.action.UniForm;
import project.check.attribute.LongNumeralCheck;
import project.master.MsgUtil;
import project.svc.generic.db.RecordOperate;
import project.web.InstanceFactory;
import project.web.generic.SearchAction;

/**
 * 汎用一覧画面
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class ListAction extends SearchAction {

	/** 削除ID */
	private static final String DEL_ID = "DelId";

	/**
	 * 削除処理
	 *
	 * @param model 汎用データモデル
	 * @return 処理結果
	 */
	public String delete(final UniForm model) {
		if (model.hasQueryString()) {
			// 入力チェック
			InputCheck ic = InstanceFactory.create(InputCheck.class, model);
			ic.add(DEL_ID, new LongNumeralCheck());
			ic.populate();

			// TODO 権限確認
			RecordOperate ro = InstanceFactory.create(RecordOperate.class, model);
			for (final Number id : model.getNumberArray(DEL_ID)) {
				if (ro.find(id, model)) {
					if (!ro.delete(model.getNumber("Id"), model.getNumber("Version"))) {
						// 削除失敗
						MsgUtil.putTopMessage(model, "ZZ000000017");
						return ID_NG;
					}
				}
			}
		}
		return ID_OK;
	}
}
