package project.web.processor;

import online.struts.action.ActionProxy;
import online.struts.action.PerformAction;
import online.struts.action.UniForm;
import online.struts.chain.command.ActionRequest;
import online.struts.chain.command.ActionRequest.CommandRequest;
import online.struts.mapping.RequestMapping;

import org.apache.commons.chain2.Processing;
import org.apache.struts.action.ActionForward;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;

import project.master.MsgUtil;
import project.web.auth.LogonAction;
import core.config.Factory;

/**
 * ログオンコマンド
 *
 * @author Tadashi Nakayama
 * @version 1.0.0
 */
public final class LogonProcessor extends ActionCommandBase implements CommandRequest {

	/**
	 * @see org.apache.struts.chain.commands.ActionCommandBase
	 * #execute(org.apache.struts.chain.contexts.ActionContext)
	 */
	@Override
	public Processing execute(final ActionContext<String, Object> context) {
		return ActionRequest.execute(context, this);
	}

	/**
	 * @see online.struts.chain.command.ActionRequest.CommandRequest
	 * #command(org.apache.struts.chain.contexts.ServletActionContext,
	 * online.struts.mapping.RequestMapping, online.struts.action.UniForm)
	 */
	@Override
	public Processing command(final ServletActionContext sac,
					final RequestMapping mapping, final UniForm uf) {
		// ログオン処理
		LogonAction la = Factory.create(LogonAction.class);
		if (la != null) {
			ActionProxy proxy = new ActionProxy(la);
			ActionForward af = proxy.execute(mapping, uf, sac.getRequest(), sac.getResponse());
			if (af != null && PerformAction.ID_OK.equals(af.getName())) {
				sac.setForwardConfig(null);
				MsgUtil.removeTopMessage(uf);
			}
		}
		return Processing.CONTINUE;
	}
}
