package project.view;

import java.io.Serializable;

/**
 * ラベルバリュー
 * @author Tadashi Nakayama
 */
public final class LabelValue implements Serializable {
	/** serialVersionUID */
	private static final long serialVersionUID = 2409858359017684463L;

	/** ラベル */
	private final String label;
	/** バリュー */
	private final String value;
	/** コメント*/
	private final String comment;

	/**
	 * コンストラクタ
	 * @param lbl ラベル
	 * @param val バリュー
	 */
	public LabelValue(final String lbl, final String val) {
		this(lbl, val, null);
	}

	/**
	 * コンストラクタ
	 * @param lbl ラベル
	 * @param val バリュー
	 * @param cmt コメント
	 */
	public LabelValue(final String lbl, final String val, final String cmt) {
		this.label = lbl;
		this.value = val;
		this.comment = cmt;
	}

	/**
	 * ラベル取得
	 * @return ラベル
	 */
	public String getLabel() {
		return this.label;
	}

	/**
	 * バリュー取得
	 * @return バリュー
	 */
	public String getValue() {
		return this.value;
	}

	/**
	 * コメント取得
	 * @return コメント
	 */
	public String getComment() {
		return this.comment;
	}
}
