/*
 * (c) Copyright Sysdeo SA 2001, 2002.
 * All Rights Reserved.
 */

package com.sysdeo.eclipse.tomcat;

import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.BROWSE_BUTTON_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_EXPORTSOURCE_LABEL;
import static com.sysdeo.eclipse.tomcat.TomcatPluginResources.WIZARD_PROJECT_WARLOCATION_LABEL;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * TomcatProjectWARPropertyPage
 *
 */
public class TomcatProjectWARPropertyPage {

	/** TEXT_FIELD_WIDTH */
	private static final int TEXT_FIELD_WIDTH = 200;

	/** TomcatProject */
	private final TomcatProject project;
	/** Shell */
	private final Shell shell;

	/** exportSourceCheck */
	private Button exportSourceCheck = null;
	/** warLocationText */
	private Text warLocationText = null;

	/**
	 * Constructor
	 * @param prj TomcatProject
	 * @param sh Shell
	 */
	public TomcatProjectWARPropertyPage(final TomcatProject prj, final Shell sh) {
		this.project = prj;
		this.shell = sh;
	}

	/**
	 * returns a control which consists of the ui elements of this page
	 * @param parent Composite
	 * @return Control
	 */
	protected Control createContents(final Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());
		createWarLocationGroup(composite);
		return composite;
	}

	/**
	 *
	 * @param parent Composite
	 */
	public void createWarLocationGroup(final Composite parent) {
		Composite warLocationGroup = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		warLocationGroup.setLayout(layout);
		warLocationGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		// location label
		Label warLocationLabel = new Label(warLocationGroup, SWT.NONE);
		warLocationLabel.setText(WIZARD_PROJECT_WARLOCATION_LABEL);
		warLocationLabel.setEnabled(true);

		// project location entry field
		this.warLocationText = new Text(warLocationGroup, SWT.BORDER);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = TEXT_FIELD_WIDTH;
		this.warLocationText.setLayoutData(data);
		this.warLocationText.setText(getWarLocation());
		this.warLocationText.setEnabled(true);

		Button browseButton = new Button(warLocationGroup, SWT.PUSH);
		browseButton.setText(BROWSE_BUTTON_LABEL);
		browseButton.addSelectionListener(new Adapter(this.shell, this.warLocationText));
		browseButton.setEnabled(true);

		this.exportSourceCheck = new Button(warLocationGroup, SWT.CHECK | SWT.LEFT);
		this.exportSourceCheck.setText(WIZARD_PROJECT_EXPORTSOURCE_LABEL);
		data = new GridData();
		data.horizontalSpan = 3;
		this.exportSourceCheck.setLayoutData(data);
		this.exportSourceCheck.setEnabled(true);
		this.exportSourceCheck.setSelection(getExportSource());
	}

	/**
	 *
	 * @return WarLocation
	 */
	protected String getWarLocation() {
		String result = "";
		TomcatProject prj = this.project;
		if (prj != null) {
			result = prj.getWarLocation();
		}
		return result;
	}

	/**
	 *
	 * @return boolean
	 */
	protected boolean getExportSource() {
		boolean result = false;
		TomcatProject prj = this.project;
		if (prj != null) {
			result = prj.getExportSource();
		}
		return result;
	}

	/**
	 * performes the ok action for this property page
	 * @return boolean
	 */
	public boolean performOk() {
		TomcatProject prj = this.project;
		prj.setWarLocation(this.warLocationText.getText());
		prj.setExportSource(this.exportSourceCheck.getSelection());
		prj.saveProperties();
		return true;
	}

	/**
	 * Adapter
	 *
	 */
	private static final class Adapter extends SelectionAdapter {

		/** Shell */
		private final Shell shell;
		/** Text */
		private final Text text;

		/**
		 * Constructor
		 * @param sh Shell
		 * @param txt Text
		 */
		Adapter(final Shell sh, final Text txt) {
			this.shell = sh;
			this.text = txt;
		}

		/**
		 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
		 */
		@Override
		public void widgetSelected(final SelectionEvent evt) {
			String newValue = warFieldChange();
			if (newValue != null) {
				this.text.setText(newValue);
			}
		}

		/**
		 *
		 * @return warFieldChange
		 */
		protected String warFieldChange() {
			File f = new File(this.text.getText());
			if (!f.exists()) {
				f = null;
			}

			File d = getFile(f);
			if (d == null) {
				return null;
			}

			return d.getAbsolutePath();
		}

		/**
		 * Helper to open the file chooser dialog.
		 * @param startingDirectory File
		 * @return File
		 */
		private File getFile(final File startingDirectory) {

			FileDialog dialog = new FileDialog(this.shell, SWT.OPEN);
			if (startingDirectory != null) {
				dialog.setFileName(startingDirectory.getPath());
			}
			String file = dialog.open();
			if (file != null) {
				file = file.trim();
				if (file.length() > 0) {
					return new File(file);
				}
			}

			return null;
		}
	}
}
