//=========================================================================
///	<summary>
///		mAgicAnimeԑgǗT[rX W[
///	</summary>
/// <remarks>
/// </remarks>
/// <history>2006/XX/XX VK쐬 Dr.Kurusugawa</history>
/// <history>2010/02/20 ÂRg폜</history>
/// <history>2010/05/01 SubversionŊǗ邽ߕsvȃRg폜</history>
//=========================================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.IO;
using System.Windows.Forms;
using System.Collections;
using System.Threading;
using System.Timers;
using System.Runtime.InteropServices;
using System.Xml;
using System.Net;
using Microsoft.Win32;
using KernelAPI;
using magicAnime.Properties;


namespace magicAnime
{
	[FlagsAttribute]
	public enum updateOption
	{
		Force			= 128,	// XV
	};

	// \񃂁[h
	public enum ReserveControl
	{
		nDaysFromNow,		// f[^XVnԂ̗\
		ImmediatlyBefore,	// Oɗ\
		noAutoReserve		// ŗ\񂵂Ȃ
	};

	public enum IdentifyFileMethod
	{
		ByCreateTimeStamp	= 0,
		ByUpdateTimeStamp	= 2,
		ByFileNameWithID	= 1,
	};

	public class UpdatingException : Exception
	{
		public UpdatingException(string mes)
			: base(mes)
		{
		}
	};
	
	//=========================================================================
	///	<summary>
	///		mAgicAnimeԑgǗT[rXNX
	///	</summary>
	/// <remarks>
	///		f[^̊Ǘ玩ăGR[h܂ōsB
	/// </remarks>
	/// <history>2006/XX/XX VK쐬</history>
	//=========================================================================
	public class AnimeServer : IDisposable
	{
		//-------------------------
		// SingletonCX^X
		//-------------------------
		private static AnimeServer theInstance;
		public static AnimeServer GetInstance()
		{
			if ( theInstance == null )
				new AnimeServer();

			return theInstance;
		}

		public const int RetryInterval	= 250;	// lbg[Nڑ̃gCԊu

		//---------------------
		// ^`
		//---------------------
		public class AnimeList : List<AnimeProgram> {};

		// Xe[^XNX
		internal struct MyStatus
		{
			internal bool	updateSequenceBusy;	// f[^XVV[PX쒆
			internal string	updateDetail;		// f[^XVڍ
			internal string resultLastUpdate;	// Ō̃f[^XVɌ
			internal bool	completeUpdate;		// f[^XVtO
		}

		public delegate void ProgressUpdateDelegate(int Phase,int MaxPhase, string d);
		public delegate void UpdateProgress(string Phase, int Perc, string desc);

		// O\fQ[g
		public delegate void LogoutDelegate(string message);
		// f[^XVV[PXsfQ[g
		private delegate void UpdateProcDelegate(
			updateOption		option		,	// [i] f[^XVIvV
			List<AnimeProgram>	prog		,	// [i] XVΏۂ̔ԑg
			UpdateProgress		onProgress	,	// [i] vOX\R[obN
			LogoutDelegate		logout		);	// [i] O\R[obN
		// u܂Ȃԁvo[̃|bvAbvfQ[g
		public delegate void PopupSoonBalloonDelegate( AnimeEpisode e );

		//---------------------
		// o
		//---------------------
		internal SyoboiCalender		mSyoboiCalender = new SyoboiCalender();	// ڂANZXIuWFNg
		// ăGR[hsGs\[h̃Xg
		internal List<WeakReference> mAutoEncodedEpisodes = new List<WeakReference>();

		private AnimeList			mAnimeList		= new AnimeList();
		private Thread				mBackGroundSequence;				// obNOEhV[PXpXbh
		private ManualResetEvent	mPulseSequenceTerminate;			// V[PXIv
		private DateTime?			mPrevSequenceTime = null;			// obNOEhV[PX̑Os
		private bool				mAutoShutdown	= false;			// GR[hɎVbg_E
		private bool				mNowEncoding;
		private	DateTime			mUpdateTime		= DateTime.Now;
		private	DateTime?			mBeforeAutoUpdateTime;				// O̎XV
		private FileSystemWatcher	mFileWatcher;						// ^fBNgĎIuWFNg
		public PopupSoonBalloonDelegate		mPopupSoonBallon;
		private AnimeProgram.EpisodeList	mPopuppedSoonEpisodes;
		private bool				mDoingUpdateSequence = false;		// f[^XVV[PXstO
		private BatchManager		mEncodeJobManager;					// GR[hWu}l[W
		private BootManager			mBootManager	= new BootManager();// u[g}l[W
		// ԂdĂEpisodẽXg
		private	List<AnimeEpisode>	mDoubleBookingEpisodes = null;
		private Mutex				mLockStatus = new Mutex();
		private MyStatus			mMyStatus;
		// Oɋf[^XVGs\[h̃Xg
		private class UpdatedSoon
		{
			internal int			mDonePoint;		// XV|Cg(nO)
			internal WeakReference	mEpisode;		// ΏۃGs\[h
		};
		private List<UpdatedSoon>	mUpdatedSoonList = new List<UpdatedSoon>();

		//---------------------
		// vpeB
		//---------------------
		public	List<AnimeEpisode> DoubleBookingEpisodes
		{
			get{ return mDoubleBookingEpisodes; }
		}
		public bool AutoShutdown
		{
			get	{ return mAutoShutdown; }
			set { mAutoShutdown = value; }
		}
		public	DateTime	UpdateDateTime		{ get{ return mUpdateTime; } }

		//=========================================================================
		///	<summary>
		///		Sԑg̃XgԂ
		///	</summary>
		/// <remarks>
		///		XgIuWFNg̃Rs[ԂB
		///		ʂXgύXẴf[^ɉeȂB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public	AnimeList	Animes
		{
			get
			{
				lock(mAnimeList)
				{
					AnimeList coppied = new AnimeList();

					foreach( AnimeProgram prog in mAnimeList )
						coppied.Add( prog );

					return coppied;
				}
			}
		}


		//=========================================================================
		///	<summary>
		///		RXgN^
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public AnimeServer()
		{
			if ( theInstance != null )
				throw new Exception("AnimeServerCX^X݂܂B");

			theInstance = this;

			mPopuppedSoonEpisodes = new AnimeProgram.EpisodeList();
		
			//------------------------------
			// ԑgf[^t@C̃[h
			//------------------------------
			lock(this)
			{

				if (File.Exists(AnimeProgramsXmlPath))
				{
					if( !Load( AnimeProgramsXmlPath ) )
					{
						//------------------------------------------
						// animePrograms.YYYYMMHH.xmlɃobNAbv
						//------------------------------------------
						try
						{
							string	strBackup;
							string strDateTime;
							
							strDateTime = string.Format(	"{0:D4}{1:D2}{2:D2}",
															DateTime.Now.Year	,
															DateTime.Now.Month	,
															DateTime.Now.Day	);

							strBackup = Path.ChangeExtension( AnimeProgramsXmlPath, strDateTime + ".xml" );

							File.Copy(	AnimeProgramsXmlPath	,
										strBackup				);
							Logger.Output( "ǂݍݎst@CobNAbv܂: " + strBackup );
						}
						catch(Exception ex)
						{
						}

						//------------------------------------
						// Õf[^t@Cǂݍ
						//------------------------------------
						if( File.Exists( AnimeProgramsPreviousXmlPath ) )
						{
							Logger.Output( "Õf[^t@Cǂݍ݂܂ - " + AnimeProgramsPreviousXmlPath );
							if( !Load( AnimeProgramsPreviousXmlPath ) )
							{
								Logger.Output( "ǂݍ݂Ɏs܂" );
							}
						}
					}
				}
			}

			//---------------------------------
			// obNOEhV[PXJn
			//---------------------------------
			
			mPulseSequenceTerminate = new ManualResetEvent( false );

			mBackGroundSequence = new Thread( new ThreadStart( this.BackGroundMain ) );
			mBackGroundSequence.Start();

			//------------------------------------
			// GR[hWu}l[W
			//------------------------------------
			mEncodeJobManager = new BatchManager( Settings.Default.concurrentNums );

			mEncodeJobManager.ProcessedEvent	+= OnEncodeJobProcessed;
			mEncodeJobManager.JobErrorEvent	+= Logger.Output;

			//-----------------------------------------
			// Wus̃AvIfmF
			//-----------------------------------------

			// GR[hɃAvꍇ̏o^
			Program.AppClosing += ClosingProc;

			try
			{
				if ( Settings.Default.autoUpdate )
					StartWatchingCaptureFolder( Settings.Default.captureFolder );

			}catch(Exception e)
			{
				Logger.Output(e.Message);
			}

		}

		//=========================================================================
		///	<summary>
		///		Dispose
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void Dispose()
		{
			if( mBackGroundSequence != null )
			{
				Logger.Output( "obNOEhV[PX~" );
				mPulseSequenceTerminate.Set();

				try
				{
					while( !mBackGroundSequence.Join( 100 ) )
					{
						Logger.Output( "...V[PX~҂" );
					}

					Logger.Output( "...V[PX~܂" );
				}
				catch( ThreadStateException )
				{
				}
			}

			Program.AppClosing -= ClosingProc;

			mEncodeJobManager.Finalize();

			EndWatchingCaptureFolder();
		}

		//=========================================================================
		///	<summary>
		///		Wus̃AvImFnh
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
	    private void ClosingProc(
	        object							sender	,
	        Program.AppClosingEventArags	e		)
		{
		    DialogResult	dr;
			BatchJob[]		jobs;
			bool			executing = false;

			jobs = mEncodeJobManager.GetCurrentJob();

			foreach( BatchJob job in jobs )
				executing |= (job != null);

			if( !executing )
			{
				e.Cancel = false;
			}
			else
			{
				//--------------------------------
				// (Wus)mFʂ\
				//--------------------------------

				dr = MessageBox.Show(
					"GR[hWusłB\n"	+
					"𒆒fĂ낵łH"	,
					"mF"								,
					MessageBoxButtons.OKCancel			,
					MessageBoxIcon.Exclamation			,
					MessageBoxDefaultButton.Button2		);

				if (dr != DialogResult.OK)
				{
					e.Cancel = true;
					return;
				}

				//----------------------
				// s̃Wu𒆒f
				//----------------------
				mEncodeJobManager.CancelJobs();
			}
		}

		//=========================================================================
		///	<summary>
		///		ԑgf[^t@Ci[t@C̃pXԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		static public string AnimeProgramsXmlPath
		{
			get
			{
				string filePath;
                filePath = Path.Combine( Program.AppDataPath, "animePrograms.xml" );
				return filePath;
			}
		}

		//=========================================================================
		///	<summary>
		///		Õf[^t@C̃pXԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2008/05/06 VK쐬</history>
		//=========================================================================
		static public string AnimeProgramsPreviousXmlPath
		{
			get
			{
				return Path.ChangeExtension( AnimeProgramsXmlPath, "previous.xml" );
			}
		}
		
		//=========================================================================
		///	<summary>
		///		ԑgf[^t@Cfo
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void Save()
		{
			string			fileName	= AnimeProgramsXmlPath;
			XmlTextWriter	xmlWriter;

			//--------------------------
			// ۑÕt@Cޔ
			//--------------------------
			try
			{
				string		prevName	= AnimeProgramsPreviousXmlPath;

				if( File.Exists( prevName ) )
					File.Delete( prevName );

				File.Move( fileName, prevName );
			}
			catch(Exception ex)
			{
			}
			
			lock(this)
			{
				xmlWriter = new XmlTextWriter( fileName, System.Text.Encoding.UTF8 );

				xmlWriter.Formatting = Formatting.Indented;

				xmlWriter.WriteStartDocument();
				
				xmlWriter.WriteStartElement("ԑg");

				foreach(AnimeProgram p in Animes)
					p.Write(xmlWriter);

				xmlWriter.WriteEndElement();
			
				xmlWriter.WriteEndDocument();

				xmlWriter.Flush();
				xmlWriter.Close();
			}
		
		}
		
		//=========================================================================
		///	<summary>
		///		ԑgf[^t@Cǂݍ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2008/05/06 Ƀt@Cn悤ɂ</history>
		//=========================================================================
		public bool Load( string fileName )
		{
			XmlTextReader x = null;
			AnimeProgram a = null;

			try
			{
				lock(mAnimeList)
				{
					x = new XmlTextReader(fileName);
					mAnimeList.Clear();

					while (x.Read())
					{
						if (x.NodeType == XmlNodeType.Element)
						{
							if (x.LocalName.Equals("ProgramInformation"))
							{
								a = new AnimeProgram( this );
								a.Read(x);
								mAnimeList.Add(a);
							}

						}//else if (x.NodeType == System.Xml.XmlNodeType.EndElement)

					}
					x.Close();
				}
			}
			catch (Exception ex)
			{
				if ( x != null )
				{
					x.Close();
				}

				Logger.Output( "f[^t@C̓ǂݍ݂Ɏs܂ - " + fileName );
				Logger.Output( "G[ڍ: " + ex.Message );

				return false;
			}

			return true;
		}

		//=========================================================================
		///	<summary>
		///		VKAjǉ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void AddAnime(AnimeProgram prog)
		{
			AddAnime(prog, -1);
		}
		public void AddAnime(AnimeProgram prog, int index)
		{
			lock( mAnimeList )
			{
				if( 0 <= index )
					mAnimeList.Insert( index, prog );
				else
					mAnimeList.Add( prog );
			}
		}

		//=========================================================================
		///	<summary>
		///		Aj^Ǘ폜
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void DeleteAnime(AnimeProgram prog)
		{
		
			lock(this)
			{
				lock( mAnimeList )
					mAnimeList.Remove( prog );

				//---------------------------------
				// ^\tg̗\LZ
				//---------------------------------
				foreach(AnimeEpisode episode in prog.Episodes)
				{
					if( episode.IsReserved )
					{
						ReserveManager rm = new ReserveManager();
						string descript;

						descript = string.Format(
							"{0:0} {1:0}b"			,
							prog.title				,
							episode.StoryNumber		);	// b

						rm.CancelReservation( descript,episode.GetUniqueString() );
					}

				}

			}

		}

		//=========================================================================
		///	<summary>
		///		Ajꗗ\[g
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2010/01/06 VK쐬</history>
		//=========================================================================
		internal void SortAnime(AnimeSort sort)
		{
			lock( mAnimeList )
				mAnimeList.Sort( sort );
			
		}

		//=========================================================================
		///	<summary>
		///		^f[^ICōXV
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void UpdateOnline(
			List<AnimeProgram>	animes	,		// [i] XVΏۂ̔ԑg
			bool				force	,		// [i] XV
			ProgressUpdateDelegate callBack )	// [i] vOXʒm
		{
			int i = 0, count;
			List<SyoboiCalender.SyoboiUpdate> updateList = null;

			SyoboiCalender syoboCal = this.mSyoboiCalender;

			count = animes.Count;

			callBack(0, count, "XV_E[hĂ܂");
			for( int j = 0 ; ; ++j )
			{
				try
				{
					updateList = syoboCal.DownloadUpdateList();
					if( updateList != null )
						break;
				}
				catch(Exception ex)
				{
					if( ex.GetType().IsSubclassOf(typeof(WebException)) )
						throw;

					if( j < Settings.Default.retryDownload )
					{
						Logger.Output(
							string.Format(
								"ڑG[̂߃gC({0}/{1})",
								j + 1, Settings.Default.retryDownload));

						Thread.Sleep( RetryInterval );
					}
					else
						throw new UpdatingException("ڂւ̃lbg[NڑG[");
				}
			}

			foreach (AnimeProgram prog in animes)
			{
				DateTime updateDate = new DateTime(2000,1,1);

				if (prog.linkOnlineDatabase)
				{
					bool update = false;

					// uOXVvُ(ݎił)ȏꍇ̑΍
					if (DateTime.Now < prog.LastUpdate)
					{
						Logger.Output("(ڂ) mAgicAnimȇOXVŝ߁A擾܂(" + prog.title + ")");
						update = true;
					}
					else
					{
						//-------------------------------
						// 1TԍXVȂ΋XV
						//-------------------------------
						if (7 <= (DateTime.Now - prog.LastUpdate).Days)
						{
							update = true;
							updateDate = DateTime.Now;
							Logger.Output("(ڂ) TԍXV񂪂Ȃ̂ŋf[^XV܂(" + prog.title + ")");
						}
						else
						{
							//-------------------------------
							// ̔ԑg̐Vf[^T
							//-------------------------------
							foreach (SyoboiCalender.SyoboiUpdate u in updateList)
							{
								if (prog.syoboiTid == u.tid)
								{
									// OXVɂڂ邪XVĂXV
									if (prog.LastUpdate < u.updateDate)
									{
										update = true;
										updateDate = (updateDate < u.updateDate) ? u.updateDate : updateDate;
										Logger.Output("(ڂ) ԑg񂪍XVĂ܂(" + u.updateDate + " - " + prog.title + ")");
									}
								}
							}

						}

					}

					if (force && !update)
					{
						updateDate	= DateTime.Now;
						update		= true;

						if( force )
							Logger.Output("(ڂ)f[^XV܂(" + prog.title + ")");
					}

					//-------------------------------
					// ԑgf[^XV
					//-------------------------------
					if(update)
						prog.UpdatePlan(updateDate);

					if (callBack != null)
						callBack(i++, count, prog.title);

				}
			}

		}

		//=========================================================================
		///	<summary>
		///		ԑg̃TlCXV
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal void UpdateThumbnail()
		{
			if (Settings.Default.forbiddenThumbnail)	// TlC쐬֎~
				return;

			foreach (AnimeProgram p in Animes)
				p.UpdateThumbnail();
		
		}

		//=========================================================================
		///	<summary>
		///		SĂ̔ԑgɑ΂AԂ̏d`FbN
		///	</summary>
		/// <remarks>
		///		ԂdSẴGs\[ho(Dx)
		///		`[i̐肸^łȂȂGs\[ho(DxL)
		/// </remarks>
		/// <history>2007/11/11 VK쐬</history>
		/// <history>2009/11/21 nȏ̏d`FbNɑΉ</history>
		/// <history>2009/11/23 `[i̐镪͏dƂȂ悤ύX</history>
		//=========================================================================
		private delegate void SweepDoubleBookingDelegate(
			SweepDoubleBookingDelegate d,
			int m,
			int i,
			DateTime startTime,
			DateTime endTime,
			List<int> path);

		internal void CheckDoubleBooking()
		{
			try
			{
				List<AnimeEpisode>	episodes		= QueryEpisode( OnAirCondition );
				List<AnimeEpisode>	conflicts		= new List<AnimeEpisode>();
				int					threshould		= Settings.Default.overlapThreshould;
				int					margin			= Settings.Default.overlapMargin;
				bool				enablePriority	= Settings.Default.enablePriority;

				// ԏɃ\[g
				episodes.Sort( new SortAnimeListOrderUpperDateTime() );

				// nd`FbN邽߁Ak^n̑Sgݍ킹XB[vB
				SweepDoubleBookingDelegate sweep = delegate(
					SweepDoubleBookingDelegate _sweep, // [i]
					int			m			,	// [i] 
					int			index		,	// [i] 
					DateTime	startTime	,	// [i] 
					DateTime	endTime		,	// [i] 
					List<int>	_path		)	// [i] Hm[hO邽߂̌oH
				{
					bool pathTerminate = true;	// gݍ킹c[̖[

					for (int i = index; i < episodes.Count - 1; ++i)
					{
						AnimeEpisode episode		= episodes[ i ];

						// 炩ɏdȂȂԑт𖳎ĒT͈͂߂
						if (endTime < episode.StartDateTime)
							break;

						if (!_path.Contains(i))
						{
							if ( episode.StartDateTime < endTime &&
								 startTime < episode.EndDateTime  )
							{
								DateTime overlapStartTime	= (startTime < episode.StartDateTime)
															? episode.StartDateTime : startTime;
								DateTime overlapEndTime		= (endTime < episode.EndDateTime)
															? endTime : episode.EndDateTime;

	//							if (m <= threshould )
								{
									if (margin < (overlapEndTime - overlapStartTime).TotalMinutes)
									{
										_path.Add(i);

										// 炩ɏdȂȂԑт𖳎ĒT͈͂߂
										// d͈ T1&T2&=[startTime,endTime] ߂ߒ
										// łԑTñCfbNXn𓾂B
										int minIndex = -1;
#if _TEST
//									_path.ForEach(delegate(int a)
//									{
//										minIndex = (minIndex < 0) ? a : Math.Min(minIndex, a);
//									});
#else
										minIndex = 0;
#endif

										_sweep(_sweep, m + 1, minIndex, overlapStartTime, overlapEndTime, _path);

										_path.RemoveAt(_path.Count - 1);

										pathTerminate = false;
									}
								}

							}
						}

					}

					if( pathTerminate )
					{
						//----------------------------------------
						// Gs\[h̑gݍ킹dƂċL^
						//----------------------------------------
						List<AnimeEpisode> episodesByPriority = new List<AnimeEpisode>();

						foreach (int j in _path)
							episodesByPriority.Add(episodes[j]);

						// ԑтdGs\[hԑgDxɃ\[g
						episodesByPriority.Sort(delegate(AnimeEpisode epA, AnimeEpisode epB)
						{
							if( epA == null && epB != null )	return -1;
							if (epA != null && epB == null)		return +1;

							if (epA.Parent.priority == epB.Parent.priority)
	// <PENDING> 2009/11/23 DxȂKɌ߂ ->
							{
								if (epA.Parent.UniqueID == epB.Parent.UniqueID)
									return 0;
								return ( epA.Parent.UniqueID < epB.Parent.UniqueID ) ? +1 : -1;
								//return 0;
							}
	// <PENDING> 2009/11/23 <-

							return (epA.Parent.priority < epB.Parent.priority) ? +1 : -1;
						});


						foreach (AnimeEpisode epi in episodesByPriority)
						{
							// `[î͏dɂȂ(DxL)
							if(  enablePriority && (threshould <= episodesByPriority.IndexOf(epi)) ||
								!enablePriority && (2 <= episodesByPriority.Count)					)
							{
								if (!conflicts.Contains(epi))
									conflicts.Add(epi);
							}
						}
					}
				};

				List<int> path = new List<int>();
				sweep(sweep, 1, 0, DateTime.MinValue, DateTime.MaxValue, path);

				mDoubleBookingEpisodes = conflicts;
			}
			catch (Exception ex)
			{
			}
		}


		//=========================================================================
		///	<summary>
		///		ԑgGs\[h̍~Ƀ\[gRyANX
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		class SortAnimeListOrderLowerDateTime : IComparer<AnimeEpisode>
		{
			public int Compare( AnimeEpisode x, AnimeEpisode y )
			{
				if ( x.StartDateTime > y.StartDateTime )
					return -1;
				else if ( y.StartDateTime > x.StartDateTime )
					return +1;
				else
					return 0;
			}
		}


		//=========================================================================
		///	<summary>
		///		ԑgGs\[h̏Ƀ\[g
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		class SortAnimeListOrderUpperDateTime : IComparer<AnimeEpisode>
		{
			public int Compare( AnimeEpisode x, AnimeEpisode y )
			{
				if ( x.StartDateTime > y.StartDateTime )
					return +1;
				else if ( y.StartDateTime > x.StartDateTime )
					return -1;
				else
					return 0;
			}
		}

		//=========================================================================
		///	<summary>
		///		K̗\񏈗(nԂ̕\)s
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal void ReserveProc(
			List<AnimeProgram>	animes		,	// [i] Ώۂ̔ԑg
			ReserveManager		manager		,	// [i] ^\}l[W
			LogoutDelegate		logout		,	// [i] Oo̓R[obN
			bool				changeOnly	)	// [i] \񎞊Ԃ̕ύX̂
		{
			//lock(this)
			//{
			List<AnimeEpisode>	list = new List<AnimeEpisode>();
			DateTime			now = DateTime.Now;

			CheckDoubleBooking();

			//----------------------------------------
			// \񂷂Gs\[hԏɗ
			//----------------------------------------
			foreach ( AnimeProgram prog in animes )
			{
				foreach( AnimeEpisode episode in prog.Episodes )
				{
					// nԂ̕\񂷂
					DateTime dateLimit = now.AddDays( Settings.Default.reserveDays );

					bool	isEnd	= episode.JudgeTimeEnd( now );
					bool	make	=	episode.HasPlan
									&&	!episode.IsReserved
									&&	episode.IsRecordRequired
									&&	(episode.StartDateTime < dateLimit)
									&&	!isEnd;
					bool	change	= episode.JudgeTimeChanged;
					bool	ignore	= episode.IsReserveError;		// \G[oĂƂ\񂵂Ȃ

					if( ((make && !changeOnly) || change) && !ignore )
					{
						list.Add( episode );
					}
				}
			}

			list.Sort( new SortAnimeListOrderLowerDateTime() );

			//--------------------
			// \񏈗s
			//--------------------

			for ( int i = 0; i < list.Count;++i )
			{
				string errorMessage;

				if( list[i].IsReservePending() )
				{
					Logger.Output( "...`[iȂ߁A\͕ۗ܂(" + list[i].ToString() + ")" );
				}
				else
				{
					if( !list[i].Reserve( manager, out errorMessage ) )
					{
						// \G[bZ[W\
						if( logout != null )
							logout( errorMessage );
					}
				}
			}

			//

			manager.Flush();

			//----------------------------------------
			// ɗ\񂪓o^Ă邩`FbN
			//----------------------------------------
			foreach (AnimeProgram p in Animes)
			{
				p.CheckReserve( manager );
			}
			
		}

		//=========================================================================
		///	<summary>
		///		^EpisodȅԂXV
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void UpdateState(
			List<AnimeProgram>	animes	,	// [i] XVΏۂ̔ԑg
			DateTime			now		,	// [i] ݎ
			string				[]files	)	// [i] 팟Ώۂ̃t@Cꗗ
		{
			if (files == null)
				files = ListupMovies();

			foreach (AnimeProgram p in animes)
			{
				p.UpdateState( now,files );
			}
		}

		
		//=========================================================================
		///	<summary>
		///		ݒ肳ꂽ^tH_t@C񋓂
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		static public string[] ListupMovies()
		{
			string[] files;

			if (!Directory.Exists(Settings.Default.captureFolder))
			{
				Logger.Output( "^tH_܂(" + Settings.Default.captureFolder.ToString() + ")" );
				files = new string[0];
				return files;
			}

			if (!Settings.Default.captureSubDir)										// TufBNg̒ɘ^t@CH
			{

				files = Directory.GetFiles(
					Settings.Default.captureFolder		,
					"*" + Settings.Default.strExtension	);								// ^t@C񋓂
			} else
			{

				files = Directory.GetDirectories( Settings.Default.captureFolder );		// ^TufBNg񋓂
			}

			return files;
		}

	
		//=========================================================================
		///	<summary>
		///		Sԑg̑SEpisode񋓂
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public int EnumAllEpisodes(
			AnimeProgram.EnumRecordCallBack	callBack	,
			object							param		)
		{
			int count = 0;

			foreach (AnimeProgram p in this.Animes)
			{
				count += p.EnumEpisodes( callBack ,param );
			}

			return count;
		}

		public delegate bool QueryEpisodeCondition( AnimeEpisode r );		// QueryEpisodȅ

		//=========================================================================
		///	<summary>
		///		ɍvEpisodẽXg𓾂
		///	</summary>
		/// <remarks>
		///		conditionnull̏ꍇ͑SĂEpisode񋓂B
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public AnimeProgram.EpisodeList QueryEpisode( QueryEpisodeCondition condition )
		{
			AnimeProgram.EpisodeList newList = new AnimeProgram.EpisodeList();

			foreach( AnimeProgram prog in Animes )
			{
				foreach( AnimeEpisode episode in prog.Episodes )
				{
					if( condition == null							||
						(condition != null && condition( episode )) )
					{
						newList.Add( episode );
					}
				}
			}

			return newList;
		}

		//=========================================================================
		///	<summary>
		///		EpisodeGR[h҂ȏ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public static bool WaitingEncodeCondition(AnimeEpisode r)
		{
			return ( r.Parent.EncoderType != null &&
					 r.HasFile && !r.IsEncoded && !r.IsStored );
		}

		//=========================================================================
		///	<summary>
		///		Episode҂ȏ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public static bool OnAirCondition(AnimeEpisode r)
		{
			return r.HasPlan && !r.JudgeTimeEnd( DateTime.Now );
		}

		//=========================================================================
		///	<summary>
		///		łGs\[h擾
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2009/06/25 VK쐬</history>
		//=========================================================================
		public AnimeEpisode QueryEarliestEpisode()
		{
			List<AnimeEpisode> epis;

			epis = QueryEpisode(AnimeServer.OnAirCondition);

			Comparison<AnimeEpisode> dateTimeComparison
				= delegate(AnimeEpisode a, AnimeEpisode b)
			{
				return a.StartDateTime.CompareTo(b.StartDateTime);
			};

			// Ƀ\[g
			epis.Sort(dateTimeComparison);

			return (0 < epis.Count) ? epis[0] : null;
		}

		//=========================================================================
		///	<summary>
		///		w肳ꂽ^t@C
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2007/04/18 V[gt@CɕϊKvȂȂ</history>
		/// <history>2009/04/30 t@Cw蕶ŃtB^IvVǉ</history>
		//=========================================================================
		static public string FindCapturedFile(
			string		UniqueID	,	// [i] Gs\[h̎ID
			DateTime	startTime	,	// [i] 
			DateTime	endTime		,	// [i] I
			string[]	movieFiles	,	// [i] t@CXg
			string		filterName	)	// [i] t@C̃tB^(IvV)
		{
			int				minMergin = Settings.Default.captureMergin;
			List<string>	matchList = new List<string>();
		
			foreach(string fn in movieFiles)
			{
				DateTime	timeStamp;
				DateTime	targetTime;
				string		sfn;				// t@C
				bool		matched	= false;	// vtO
				bool		isDir	= false;

				switch (Settings.Default.specifiedFile)
				{
				case IdentifyFileMethod.ByCreateTimeStamp:
				case IdentifyFileMethod.ByUpdateTimeStamp:
					//-----------------------
					// 쐬(XV)œ
					//-----------------------
					sfn = fn + ".";

					isDir	=	Directory.Exists(sfn)
							&&	(0 < (File.GetAttributes(sfn) & FileAttributes.Directory));

					if( Settings.Default.specifiedFile == IdentifyFileMethod.ByCreateTimeStamp )
					{
						timeStamp	= isDir	?	Directory.GetCreationTime(sfn)	:
												File.GetCreationTime(sfn)		;
						targetTime	= startTime;
					}
					else
					{
						timeStamp	= isDir	?	Directory.GetLastWriteTime(sfn)	:
												File.GetLastWriteTime(sfn)		;
						targetTime	= endTime;
					}

					matched	= (Math.Abs( (targetTime - timeStamp).TotalMinutes ) < minMergin);
					
					break;
				case IdentifyFileMethod.ByFileNameWithID:
					//-----------------------
					// t@CIDœ
					//-----------------------
					if (0 <= fn.IndexOf(UniqueID+"_"))							// t@CID邩H
					{
						matched = true;
					}

					break;
				}

				if( matched )													// vH
				{
					if (Settings.Default.captureSubDir)							// TufBNgɃt@C邩H
					{
						string[]	files;
						string		dir;

						dir = fn + ".";

						if ((File.GetAttributes( dir ) & FileAttributes.Directory) > 0)		// fBNgH
						{
							string ext = Settings.Default.strExtension;			// ^t@C̋K̊gq
							files = Directory.GetFiles( dir, "*" +  ext );		// TufBNg̃t@C

							if (files.Length > 0)
								matchList.Add( files[0] );		// TufBNg̈Ԗڂ̘^t@C^[QbgƂ
						}

					}else{
						matchList.Add( fn );
					}

				}
				
			}

			//------------------------------------------
			// Xg̃t@Cw蕶ŃtB^
			//------------------------------------------
			if( !string.IsNullOrEmpty( filterName ) )
			{
				List<string>	remList = new List<string>();
				foreach (string fn in matchList)
				{
					if ( fn.ToUpper().IndexOf(filterName.ToUpper()) < 0 )
					{
						remList.Add( fn );
					}
				}

				foreach( string fn in remList )
					matchList.Remove( fn );
			}

			if( 1 <= matchList.Count )
				return matchList[ 0 ];
		
			return null;
		}

		//=========================================================================
		///	<summary>
		///		蓮ŃGR[hWu𓊓(񓯊)
		///	</summary>
		/// <remarks>
		///		WudēĂ
		///		蓮GR[hɎGR[h̎ԂĂWuǉȂ
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public void AddEncodeJob(AnimeEpisode record)
		{
			EncodeJob job = new EncodeJob(record);

			if( mEncodeJobManager.Contains(job) )
				return;

			if( !mNowEncoding )
			{
				mAutoShutdown = false;
			}

			mNowEncoding = true;

			mEncodeJobManager.AddJob(job);
		}

		//=========================================================================
		///	<summary>
		///		ob`o^ĂGR[hWuXgԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public List<EncodeJob> GetQueueingEncodeJobs()
		{
			List<EncodeJob> encodeJobs = new List<EncodeJob>();
			BatchJob[] jobs;

			jobs = mEncodeJobManager.GetQueueingJobs();

			// EncodeJob̂ݐ􂢏o
			foreach (BatchJob job in jobs)
			{
				if (job.GetType() == typeof(EncodeJob))
				{
					encodeJobs.Add((EncodeJob)job);
				}
			}

			return encodeJobs;
		}

		//=========================================================================
		///	<summary>
		///		GR[h̃WuԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public EncodeJob[] GetCurrentJobs()
		{

			BatchJob[]			jobs;
			List<EncodeJob>		encodeJobs = new List<EncodeJob>();
			
			jobs = mEncodeJobManager.GetCurrentJob();

			foreach( BatchJob job in jobs )
			{
				if (job != null &&
					job.GetType() == typeof(EncodeJob))
				{
					encodeJobs.Add( (EncodeJob)job );
				}
			}

			if( 0 < encodeJobs.Count )
				return encodeJobs.ToArray();

			return new EncodeJob[0];
		}

		//=========================================================================
		///	<summary>
		///		GR[hWuSăLZ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2008/11/16 VK쐬</history>
		//=========================================================================
		internal void CancelJobs()
		{
			mEncodeJobManager.CancelJobs();
		}

		//=========================================================================
		///	<summary>
		///		GR[hWu1Ȉ
		///	</summary>
		/// <remarks>
		///		Vbg_EvpeBTruêƂAVbg_EB
		///		蓮ŒǉƂ̓Vbg_EȂB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void OnEncodeJobProcessed(
			BatchJob		job		,	// [i] Wu
			bool			last	)	// [i] TRUE:Ō̃Wu FALSE:ɃWu
		{
			//if (job.GetType() == typeof(EncodeJob))
			{
				// cWu0ȂVbg_E...
				if ( last )
				{
					mNowEncoding = false;

					if( AutoShutdown )
					{
						Logger.Output( "GR[hWuSɂVbg_E" );
						Program.TryShutdown();
					}
				}
			}
		}

		//=========================================================================
		///	<summary>
		///		GR[h̑SĂEpisodeGR[hob`Wu
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public int BatchEncodeAll()
		{
			//---------------------------------------------
			// GR[h\ȏԂEpisodeXgAbv
			//---------------------------------------------
			AnimeProgram.EpisodeList list = QueryEpisode( WaitingEncodeCondition );

			mAutoShutdown = Settings.Default.autoShutdownAtEncoded;
			mNowEncoding = true;

			//-------------------------------------
			// GR[hob`WuGL[
			//-------------------------------------
			foreach( AnimeEpisode episode in list )
			{
				mEncodeJobManager.AddJob( new EncodeJob( episode ) );
			}
			
			// ǉWuԂ
			int		totalCount = mEncodeJobManager.JobCount;

			if( totalCount == 0 )
				mNowEncoding = false;

			string		log;
			log = string.Format(	"SGR[hWu𓊓 - ǉWu:{0:0} ҋ@Wu:{1:0}",
									list.Count		,
									totalCount		);
			Logger.Output( log );

			return list.Count;
		}

		//=========================================================================
		///	<summary>
		///		N̎s
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2008/05/04 OnInterval番</history>
		//=========================================================================
		private void FirstProc()
		{
			if( Settings.Default.autoTransferAtBoot )
			{
				//-------------------------
				// Nɕۑ֓]
				//-------------------------
				try
				{
					int count = 0;

					Logger.Output( "[V[PX] Nɕۑ֓]..." );

					AnimeProgram.EpisodeList list;

					list = QueryEpisode( delegate (AnimeEpisode ep)
					{
						bool bExclude	=	Settings.Default.autoMoveWithoutFirstEpisode
										&&	(ep.StoryNumber == 1);

						return		ep.IsStorable
								&&	!ep.IsStored
								&&	!bExclude;
					});

					foreach( AnimeEpisode ep in list )
					{
						try
						{
							ep.Store();
							++count;
						}
						catch( EpisodeMethodException ex )
						{
							Logger.Output( "(])" + ex.Message );
						}
					}

					if ( 0 < count )
					{
						Logger.Output( "(N])ۑ(" + Settings.Default.saveFolder + ")" + count.ToString() + "{ړ܂B" );
					}
				}
				catch ( Exception ex )
				{
					Logger.Output( "(])" + ex.Message + ex.StackTrace );
				}
			}
		}


		//=========================================================================
		///	<summary>
		///		obNOEhV[PX
		///	</summary>
		/// <remarks>
		///		obNOEhŎsAw̎ɃGR[hWu̓Ȃ
		///		sB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2008/07/20 Xbhŏ</history>
		/// <history>2008/10/01 OɃo[\@\ǉ</history>
		//=========================================================================
		void BackGroundMain()
		{
			Logger.Output( "[V[PX] obNOEhV[PXJn܂" );

			//----------------------
			// ÑEFCg
			//----------------------
			long	wait = Settings.Default.startupWait;

			Logger.Output("[V[PX] ÑEFCg(" + wait.ToString() + "sec)");

			DateTime	endTime = DateTime.Now.AddSeconds( wait );

			for (; ; )
			{
				if (mPulseSequenceTerminate.WaitOne(0, false))
				{
					Logger.Output("...f");
					break;
				}

				if( 0 <= DateTime.Now.CompareTo( endTime ) )
				{
					Logger.Output("...OK");
					break;
				}
			}

			//----------------------
			// N̎
			//----------------------

			Logger.Output( "[V[PX] N̏" );

			FirstProc();

			for(;;)
			{
				//----------------------------------
				// IvmFAyуX[v
				//----------------------------------
				if( mPulseSequenceTerminate.WaitOne( 5000, false ) )
				{
					Logger.Output( "[V[PX] obNOEhV[PXI܂" );
					break;
				}

				// OƓꎞ
				DateTime	nowDateTime	= DateTime.Now;
				bool		haveJust	= false;

				if( mPrevSequenceTime.HasValue )
				{
					haveJust	= ( (mPrevSequenceTime.Value.Hour	== nowDateTime.Hour)	&&
									(mPrevSequenceTime.Value.Minute	== nowDateTime.Minute)	);
				}

				//----------------------------------------
				// IA莞Ԍɕۑ֓]
				//----------------------------------------
				if( Settings.Default.autoTransferAtAfterRecord )
				{
					AutoTrasnferProc();
				}

				//----------------------------------------
				// IA莞ԌɍăGR[h
				//----------------------------------------
				if( Settings.Default.autoEncodeInAfterRecord )
				{
					AutoEncodeProc();
				}

				//-------------------------------------------
				// w莞ɎIɃGR[hWu𓊓
				//-------------------------------------------
				if(	Settings.Default.scheduleEncodeEveryday	&&
					mNowEncoding == false					)
				{
					int			encodeTime	= Settings.Default.scheduleEncodeTime;
					bool		arise		= false;

					arise = ( nowDateTime.Hour	== encodeTime / 60	&&
							 nowDateTime.Minute	== encodeTime % 60	);

					if ( arise && !haveJust )
					{
						int count;

						//-------------------------
						// ob`GR[h
						//-------------------------
						Logger.Output( "[V[PX] ob`GR[hJn" );

						count = BatchEncodeAll();

						// GR[ht@CȂ΃Vbg_E
						if(count == 0)
						{
							Logger.Output( "[V[PX] ...KvȂ" );
							if( mAutoShutdown )
							{
								Logger.Output( "[V[PX] ...ɃVbg_E" );
								Program.TryShutdown();
							}
						}
					}
				}

				//----------------------------
				// Oɋf[^XV
				//----------------------------
				if( Settings.Default.updateOnAirSoon )
					UpdateOnAirSoon();

				//----------------------------
				// 莞ԂƂɃf[^XV
				//----------------------------
				if( Settings.Default.autoRefresh )
				{
					// ͍XVAXV(NXVƏd邽)
					if( !mBeforeAutoUpdateTime.HasValue )
					{
						mBeforeAutoUpdateTime = nowDateTime;
					}

					if ( ( DateTime.Now - mBeforeAutoUpdateTime.Value ).TotalMinutes >= Settings.Default.updateInterval )
					{
						Logger.Output( "[V[PX] XV" );
						BeginUpdate( 0 );

						mBeforeAutoUpdateTime = DateTime.Now;
					}

				}

				//-------------------------------
				// ԑgOɃo[\
				//-------------------------------
				if( Settings.Default.showSoonBalloon )
				{
					DateTime	now				= DateTime.Now;
					int			popupMergin		= Settings.Default.timeSoonBalloon;

				   // 莞ԑO`𔻒
				   QueryEpisodeCondition isBroadcastingSoon = delegate (AnimeEpisode r)
				   {
						if( !r.HasPlan )
							return false;

						return (r.StartDateTime.AddMinutes( -popupMergin ) <= now)	&&
								(now < r.StartDateTime)										;
				   };

				   AnimeProgram.EpisodeList	soonEpisodes;
				   soonEpisodes = QueryEpisode( isBroadcastingSoon );

					// Ƀ|bvAbv\Gs\[hO
					Predicate<AnimeEpisode> isAlreadyPopupped = delegate (AnimeEpisode r)
					{
						return mPopuppedSoonEpisodes.Contains( r );
					};
					soonEpisodes.RemoveAll( isAlreadyPopupped );
					
					// |bvAbvσXgԂ߂Gs\[h폜
					Predicate<AnimeEpisode> isAlreadyBroadcasted = delegate (AnimeEpisode r)
					{
						if( !r.HasPlan )
							return true;

						return r.EndDateTime < now;
					};
					mPopuppedSoonEpisodes.RemoveAll( isAlreadyBroadcasted );


				   foreach( AnimeEpisode episode in soonEpisodes )
				   {
						if( mPopupSoonBallon != null )
							mPopupSoonBallon( episode );

						// Ƀ|bvAbv\Gs\[hLĂ
						mPopuppedSoonEpisodes.Add( episode );
					}
				}

				mPrevSequenceTime = nowDateTime;

				// Oɗ\郂[h
				if (Settings.Default.reserveControl == ReserveControl.ImmediatlyBefore)
				{
					ReserveImmediatlyBefore( Settings.Default.reserveImmediatlyBeforeMinutes );
				}
			}

		}

		//=========================================================================
		///	<summary>
		///		I̎]
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2008/05/04 OnInterval番</history>
		//=========================================================================
		private void AutoTrasnferProc()
		{
			try
			{
//				AnimeEpisode stored = null;
				DateTime now = DateTime.Now;

				List<AnimeEpisode> episodes;

				episodes = QueryEpisode( delegate (AnimeEpisode ep)
				{
					if( ep.HasFile && !ep.IsStored && ep.IsStorable )
					{
						DateTime endTime = ep.EndDateTime.AddMinutes( Settings.Default.autoTransferTime );

						// ^AH
						if ( ( endTime <= now ) &&
							(( now - endTime ).Ticks / TimeSpan.TicksPerSecond) < 60 )
						{
							bool	exclude = false;
							// 1b͏OIvV
							exclude =	Settings.Default.autoMoveWithoutFirstEpisode
									&&	(1 == ep.StoryNumber);

							return !exclude;
						}
					}
					return false;
				} );

				foreach( AnimeEpisode ep in episodes )
				{
					ep.Store();
					Logger.Output( "(㎩])ۑ(" + Settings.Default.saveFolder + ")" + ep.ToString() + "ړ܂B" );
				}

			}
			catch ( Exception ex )
			{
				Logger.Output( "(])" + ex.Message + ex.StackTrace );
			}
		}

		//=========================================================================
		///	<summary>
		///		I̍ăGR[hJn
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2008/05/04 VK쐬</history>
		//=========================================================================
		private void AutoEncodeProc()
		{
			try
			{
				AnimeEpisode				target		= null;
				DateTime					now			= DateTime.Now;
				AnimeProgram.EpisodeList	targetEpisodes;

				// u^ρvuInṽGs\[h
				targetEpisodes = QueryEpisode(delegate(AnimeEpisode ep)
				{
					if( ep.HasFile && !ep.IsEncoded && !ep.IsStored )
					{
						DateTime triggerTime = ep.EndDateTime.AddMinutes(
												Settings.Default.autoEncodeMergin );

						// InH
						return	(triggerTime <= now)
							&&	(now < triggerTime.AddMinutes(1));
					}
					return false;
				} );

				foreach (AnimeEpisode episode in targetEpisodes)
				{
					// ɏGs\[h͖
					bool alreadyProcessed = false;
					alreadyProcessed = mAutoEncodedEpisodes.Exists( delegate (WeakReference epRef)
					{
						AnimeEpisode ep = epRef.Target as AnimeEpisode;
						return (ep != null) && (ep == episode);
					} );

					if (!alreadyProcessed)
					{
						mAutoEncodedEpisodes.Add(new WeakReference(episode));

						// ̕Ԃ܂ŎԂȂ΃GR[hJnȂ
						if (Settings.Default.dontBeginEncodeLessThanMinutes)
						{
							AnimeEpisode earliestEpis;
							earliestEpis = QueryEarliestEpisode();

							TimeSpan span = (earliestEpis.StartDateTime - DateTime.Now);

							if (span.TotalMinutes < Settings.Default.maxDelayTimeDontBeginEncode)
							{
								Logger.Output("(㎩ăGR[h)̕܂ŎԂȂ߃GR[hJn܂ - " + episode.ToString());
								break;
							}
						}

						//-------------------------
						// GR[hWu
						//-------------------------
						AddEncodeJob(episode);

						if (target != null)
						{
							Logger.Output("(㎩ăGR[h)ob`Wu𓊓܂ - " + target.ToString());
						}
					}
				}
			}
			catch ( Exception ex )
			{
				Logger.Output( "(㎩ăGR[h)" + ex.Message + ex.StackTrace );
			}
		}

		//=========================================================================
		///	<summary>
		///		OnOɗ\
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2009/06/26 VK쐬</history>
		//=========================================================================
		private void ReserveImmediatlyBefore(
			int		beforeMin	)	// [i] JnnO
		{
			try
			{
				DateTime			now			= DateTime.Now;
				List<AnimeEpisode>	immedEpisodes;

				CheckDoubleBooking();

				immedEpisodes = QueryEpisode(delegate(AnimeEpisode ep)
				{
					if( ep.HasPlan && ep.IsRecordRequired && !ep.IsReserved )
					{
						return	(	(ep.StartDateTime.AddMinutes(-beforeMin) <= now)
								&&	(now < ep.StartDateTime) );
					}
					return false;
				} );

				foreach( AnimeEpisode ep in immedEpisodes )
				{
					string	err;

					if( ep.IsReservePending() )
					{
						Logger.Output( "(O\) `[iȂ߁A\͕ۗ܂(" + ep.ToString() + ")" );
					}
					else
					{
						if( ep.Reserve(new ReserveManager(), out err) )
							Logger.Output( "(O\) \񊮗 - " + ep.ToString() );
						else
							Logger.Output("(O\) \񎸔s(" + err + ") - " + ep.ToString());
					}
				}

				foreach (AnimeEpisode ep in immedEpisodes)
					ep.Dirty = true;
			}
			catch( Exception ex )
			{
				Logger.Output( "(O\) G[(" + ex.Message + ")" );
			}
		}

		//=========================================================================
		///	<summary>
		///		f[^XVJn(񓯊)
		///	</summary>
		/// <remarks>
		///		JnɐtrueԂB
		/// </remarks>
		/// <history>2006/11/26 VK쐬</history>
		/// <history>2008/10/21 񓯊ɉCBG[O\pR[obNǉB</history>
		//=========================================================================
		public bool BeginUpdate(
			updateOption		option	)	// [i] f[^XVIvV
		{
			return BeginUpdate( option, null );
		}
		public bool BeginUpdate(
			updateOption		option	,	// [i] f[^XVIvV
			List<AnimeProgram>	animes	)	// [i] XVԑgXg
		{
			UpdateProcDelegate	delUpdate	= UpdateSequence;
			ManualResetEvent	endFlag		= new ManualResetEvent( false );
			// oߕ\
			UpdateProgress		progDelgate	= delegate (string Phase, int perc, string text )
			{
				if( mLockStatus.WaitOne() )
				{
					mMyStatus.updateDetail = Phase + " " + text;
					mLockStatus.ReleaseMutex();
				}
			};
			//---------------------
			// Oo
			//---------------------
			LogoutDelegate		logoutDelgate	= delegate (string text)
			{
				if (mLockStatus.WaitOne())
				{
					if ( !string.IsNullOrEmpty( mMyStatus.resultLastUpdate ) )
						mMyStatus.resultLastUpdate += System.Environment.NewLine;

					mMyStatus.resultLastUpdate += text;

					Logger.Output( text );

					mLockStatus.ReleaseMutex();
				}
			};

			//---------------------
			// 
			//---------------------
			AsyncCallback completeCallback = delegate(IAsyncResult result)
			{
				if (mLockStatus.WaitOne())
				{
					mMyStatus.completeUpdate = true;
					mLockStatus.ReleaseMutex();
				}

				mDoingUpdateSequence = false;
				endFlag.Set();
			};

// <PENDIG> 2009/11/23 IɌʂNAH ->
//			if (mLockStatus.WaitOne())
//			{
//				mThisStatus.resultLastUpdate = "";
//				mLockStatus.ReleaseMutex();
//			}
// <PENDIG> 2009/11/23 <-

			if( animes == null )
				animes = this.Animes;

			try
			{
				if( mDoingUpdateSequence )
				{
					// Ɏs...
					return false;
				}

				endFlag.Reset();

				// f[^XVV[PXJn
				delUpdate.BeginInvoke(
					option,
					animes,
					progDelgate,
					logoutDelgate,
					completeCallback,
					null);

				mDoingUpdateSequence = true;
			}
			catch(Exception)
			{
				return false;
			}

			return true;
		}


		//=========================================================================
		///	<summary>
		///		f[^XVV[PX
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2008/10/21 VK쐬</history>
		//=========================================================================
		private void UpdateSequence(
			updateOption		option		,	// [i] f[^XVIvV
			List<AnimeProgram>	animes		,	// [i] XVΏۂ̔ԑg
			UpdateProgress		onProgress	,	// [i] vOX\R[obN
			LogoutDelegate		logout		)	// [i] O\R[obN
		{

			try
			{
				//-------------------------------------
				// ICf[^[x[XXV
				//-------------------------------------

				if( onProgress != null )
				{
					onProgress( "ICf[^x[XɃANZX", 0, null );
				}

				AnimeServer.ProgressUpdateDelegate onOnlineProgress = delegate(
					int			perc	,
					int			max		,
					string		descipt	)
				{
					//---------------------------------------
					// XV̌o߂ʂɃR[obN
					//---------------------------------------
					if (max == 0) max = 1;
					if( onProgress != null )
					{
						onProgress(	"ICf[^x[XɃANZX",
									100 * perc / max				,
									descipt							);
					}
				};

				bool force = ((option & updateOption.Force) != 0);	// XVtO

				UpdateOnline(animes, force, onOnlineProgress);

				//-------------------------------------
				// EpisodeԂ̍XV
				//-------------------------------------

				if( onProgress != null )
				{
					onProgress( "^t@C̒TƏԂ̍XV", 0, null );
				}

				UpdateState(animes, DateTime.Now, null);

				//-------------------------------------
				// ^\
				//-------------------------------------

				{
					if (onProgress != null)
					{
						onProgress("^\", 0, null);
					}

					bool	changeOnly = false;
					changeOnly = (Settings.Default.reserveControl != ReserveControl.nDaysFromNow);

					ReserveProc(animes, new ReserveManager(), logout, changeOnly);
				}

				//-------------------------------------
				// dݒ
				//-------------------------------------

				if (Settings.Default.autoPowerManagement)
				{
					if( onProgress != null )
					{
						onProgress( "PCNݒ", 0, null );
					}

					ApplyBootSchedule();
				}

				//-------------------------------------
				// TlCXV
				//-------------------------------------

				if( onProgress != null )
				{
					onProgress( "TlCXV", 0, null );
				}

				UpdateThumbnail();

				// ԏd̃`FbN
				if( onProgress != null )
				{
					onProgress( "Ԃ̏d`FbN", 0, null );
				}

				CheckDoubleBooking();

				//-------------------------------------
				// XV
				//-------------------------------------

				if( onProgress != null )
				{
					onProgress( "XV", 0, null );
				}

				Save();
			}
			catch(UpdatingException e)
			{
				if( logout != null )
					logout("f[^XVG[(" + e.Message +")");
			}
			catch (Exception e)
			{
				{
					Logger.Output("G[ڍ: " + e.Message + "(" + e.StackTrace + ")");

					if( logout != null )
						logout("\ȂG[܂B(ڍׂ̓OQ)");
				}
			}

			GC.Collect();
		}

		//=========================================================================
		///	<summary>
		///		AvP[Vݒ肪ύXꂽAIɐݒ𔽉f
		///	</summary>
		/// <remarks>
		///		IvVʂꂽ^C~OȂǂŌĂԂƁB
		/// </remarks>
		/// <history>2009/02/14 VK쐬</history>
		//=========================================================================
		internal void ApplyOption()
		{
			Logger.Output( "AvP[Vݒ肪ύX܂B" );

			try
			{
				//---------------------
				// ^tH_̊Ď
				//---------------------
				EndWatchingCaptureFolder();

				if( Settings.Default.autoUpdate )
					StartWatchingCaptureFolder( Settings.Default.captureFolder );

			}
			catch (Exception e)
			{
				Logger.Output(e.Message);
			}
		}

		//=========================================================================
		///	<summary>
		///		^ptH_̊ĎJn
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private bool StartWatchingCaptureFolder( string watchPath )
		{
			Logger.Output("...^tH_Ď(" + watchPath + (")"));

			if (mFileWatcher != null)
			{
				Logger.Output("......G[(ɃANeBu)");
				return false;
			}

			try
			{

				if (!Directory.Exists(watchPath))
				{
					Logger.Output( "......G[(pXݒ肳Ă܂)" );
					return false;
				}

				mFileWatcher = new FileSystemWatcher();

				mFileWatcher.Path			= watchPath;
				mFileWatcher.Filter			= "";
				mFileWatcher.NotifyFilter	= NotifyFilters.FileName | NotifyFilters.DirectoryName;
				mFileWatcher.Created			+= new FileSystemEventHandler( OnCreatedCaptureFile );

				mFileWatcher.EnableRaisingEvents = true;

				Logger.Output("......OK");
			}
			catch ( Exception )
			{
				mFileWatcher = null;
				Logger.Output("......G[");
				return false;
			}

			return true;
		}

		//=========================================================================
		///	<summary>
		///		^tH_Ď𒆎~
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void EndWatchingCaptureFolder()
		{
			if ( mFileWatcher != null )
			{
				mFileWatcher.EnableRaisingEvents = false;
				mFileWatcher.Dispose();

				mFileWatcher = null;
			}
		}


		//=========================================================================
		///	<summary>
		///		^tH_Ƀt@C쐬ꂽꍇ̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2008/05/03 \bhύX(onFileChanged->OnCreatedCaptureFile)</history>
		//=========================================================================
		private void OnCreatedCaptureFile(
			System.Object source,
			System.IO.FileSystemEventArgs e )
		{
			try
			{
				if ( Settings.Default.autoUpdate )	// Abvf[gIvV
				{

					if ( e.ChangeType == System.IO.WatcherChangeTypes.Created )
					{
						DateTime nowDateTime = DateTime.Now;

						// TufBNgĂ璆Ƀt@C܂
						// ^CÔŏsleepĂ
						if ( Settings.Default.captureSubDir )
						{
							Thread.Sleep( 3000 );

						} else
						{
							// ֌WȊgq̃t@CȂ珈Ȃ
							if ( !Path.GetExtension( e.FullPath ).Equals( Settings.Default.strExtension ) )
								return;
						}

						string[] temp = { e.FullPath };

						UpdateState( Animes, DateTime.Now, temp );
					}

				}

			}
			catch ( Exception ex )
			{
				Logger.Output( ex.Message );
			}

		}

		//=========================================================================
		///	<summary>
		///		BootTimerPCNXPW[𔽉f
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		/// <history>2009/06/29 BootManagerړ</history>
		//=========================================================================
		public void ApplyBootSchedule()
		{
			if (!Settings.Default.autoPowerManagement)
				return;

			mBootManager.Clear();

			//--------------------------------------------------
			// \ς̃Gs\[hNXPW[Xgɓo^
			//--------------------------------------------------
			AnimeProgram.EpisodeList	episodeList;
			DateTime					now			= DateTime.Now;

			// N
			if( (Settings.Default.reserveControl == ReserveControl.ImmediatlyBefore)
			||  (Settings.Default.reserveControl == ReserveControl.noAutoReserve) )
			{
				//----------------------------------------
				// (Oɗ\)nԂ̕
				//----------------------------------------
				episodeList = QueryEpisode(delegate(AnimeEpisode ep)
				{
					if (ep.Parent.WithoutPower)
						return false;

					// uvȊOłΕԃf[^
					if( ep.HasPlan )
					{
						// nȓ
						{
							int nDays = Settings.Default.autoBootNDays;

							var endTime = ep.EndDateTime.AddMinutes(Settings.Default.shutdownPutoff);

							if ((now <= endTime) &&
								(ep.EndDateTime < now.AddDays(nDays)))
							{
								return true;
							}
						}
					}
					return false;
				});
			}
			else
			{
				//----------------------
				// \ς̕
				//----------------------
				episodeList = QueryEpisode(delegate(AnimeEpisode episode)
				{
					if (episode.Parent.WithoutPower)
						return false;
					return	episode.HasPlan && episode.IsReserved;
				});
			}

			// NXPW[ɒǉ
			foreach (AnimeEpisode episode in episodeList)
			{
				DateTime startTime, endTime;

				startTime	= episode.StartDateTime;
				endTime		= episode.EndDateTime;

				// l̔ԑg^Cg
				mBootManager.Add(startTime, endTime, episode.Parent.title);
			}

			// ߂ԑѓm
			mBootManager.Sort(new BootManager.ITimeZoneComparer());
			mBootManager.Unification();

			mBootManager.ApplyBootTimer( DateTime.Now );
		}

		//=========================================================================
		///	<summary>
		///		ύXtO
		///	</summary>
		/// <remarks>
		///		f[^ύXĂtrueԂB
		///		ʂfalseZbgĕ\XVKvȃ^C~O҂B
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		internal bool Dirty
		{
			get
			{
				bool childDirty = false;
				lock (mAnimeList)
				{
					foreach (AnimeProgram prog in mAnimeList)
						childDirty |= prog.Dirty;
				}

				return childDirty;
			}
			set
			{
				if (!value)
				{
					lock (mAnimeList)
					{
						foreach (AnimeProgram prog in mAnimeList)
							prog.Dirty = false;
					}
				}
//				isDirty = value;
			}
		}

		//=========================================================================
		///	<summary>
		///		IuWFNg̃Xe[^XԂ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2009/11/23 VK쐬</history>
		//=========================================================================
		internal MyStatus GetStatus()
		{
			MyStatus copied;

			if (!mLockStatus.WaitOne())
				throw new Exception("G[(GetStatus)");

			mMyStatus.updateSequenceBusy = mDoingUpdateSequence;

			copied = mMyStatus;

			mLockStatus.ReleaseMutex();

			return copied;
		}

		//=========================================================================
		///	<summary>
		///		f[^XVʂNA
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2009/11/23 VK쐬</history>
		//=========================================================================
		internal void ClearResultUpdate()
		{
			if (!mLockStatus.WaitOne())
				throw new Exception("G[(ClearResultUpdate)");

			mMyStatus.resultLastUpdate = "";

			mLockStatus.ReleaseMutex();
		}

		//=========================================================================
		///	<summary>
		///		f[^XVtONA
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2009/11/23 VK쐬</history>
		//=========================================================================
		internal void ResetCompleteUpdate()
		{
			if (!mLockStatus.WaitOne())
				throw new Exception("G[(ResetCompleteUpdate)");

			mMyStatus.completeUpdate = false;

			mLockStatus.ReleaseMutex();
		}

		//=========================================================================
		///	<summary>
		///		Oɋf[^XV
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2010/01/27 VK쐬</history>
		//=========================================================================
		private void UpdateOnAirSoon()
		{
			var			episodes	= QueryEpisode( ep => true );
			DateTime	now			= DateTime.Now;
			List<int>	untilOnAir	= Settings.Default.untilOnAirMinutes;
			var			target		= new List<AnimeProgram>();

			foreach( AnimeEpisode ep in episodes )
			{
				if( ep.HasPlan )
				{
					// ܂ł̎[min]
					long	remain		= (long)(ep.StartDateTime - now).TotalMinutes;
					var		passedPoint	= new List<int>();

					// o߂`FbN|Cg(n1,n2...O)擾
					foreach( int point in untilOnAir )
						if( remain < point )
							passedPoint.Add( point );

					passedPoint.Sort();

					if( 0 < remain )
					{
						if( 0 < passedPoint.Count )
						{
							// ʉ߂߂̃`FbN|Cg
							int			minPoint	= passedPoint[0];
							UpdatedSoon entry;
							bool		exec		= false;

							// ŌɎs`FbN|Cgi񂾂
							entry = mUpdatedSoonList.Find( e => (e.mEpisode.Target == ep) );

							if( entry != null )
								exec = (minPoint < entry.mDonePoint);
							else
								exec = true;

							if( exec )
							{
								Logger.Output( "[V[PX] " + minPoint.ToString() + "O f[^XV"
											 + "(" + ep.Parent.title + ")" );

								if( !target.Contains( ep.Parent ) )
									target.Add( ep.Parent );

								// XV|CgL^
								if( entry != null )
									entry.mDonePoint = minPoint;
								else
								{
									entry = new UpdatedSoon();
									entry.mDonePoint		= minPoint;
									entry.mEpisode			= new WeakReference(ep);
									mUpdatedSoonList.Add( entry );
								}
							}
						}
					}
				}
			}

			if( 0 < target.Count )
				BeginUpdate( updateOption.Force, target );

			// sσXgN[Abv
			var deadList = mUpdatedSoonList.FindAll(
				delegate (UpdatedSoon entry)
			{
				AnimeEpisode ep = entry.mEpisode.Target as AnimeEpisode;
				if( ep != null )
					return (ep.HasPlan && ep.StartDateTime < now);
				return false;
			} );

			mUpdatedSoonList.RemoveAll( entry => deadList.Contains(entry) );
		}

	}


}
