//=========================================================================
///	<summary>
///		mAgicAnimeԑgvpeB W[
///	</summary>
/// <remarks>
/// </remarks>
/// <history>2006/XX/XX VK쐬 Dr.Kurusugawa</history>
/// <history>2010/05/01 SubversionŊǗ邽ߕsvȃRg폜</history>
//=========================================================================
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Collections;
using System.Windows.Forms;
using System.Threading;
using magicAnime.UserInterface;

namespace magicAnime
{
	//=========================================================================
	///	<summary>
	///		mAgicAnimeԑgvpeBʃNX
	///	</summary>
	/// <remarks>
	/// </remarks>
	/// <history>2006/XX/XX VK쐬</history>
	//=========================================================================
	internal partial class AnimeDialog : Form
	{
		//--------------------
		// oϐ
		//--------------------
		private AnimeProgram			mProgram;
		private SyoboiCalender			mSyoboCal;
		private int						mSelectedTid;
		private Hashtable				mEncoderTable;
		private Form					mEncoderForm;
		private Type					mCurrentEncoder;					// ݂̃GR[_ݒ
		private EncodeProfile			mCurrentProfile;
		private Scheduler.ProfilePage	mProfilePage;
		private int						mZappingTid				= 0;		// ITID
		private string					mSelectTvStation		= null;
		private string					mInputTitle				= null;
		private bool					mLinkOnline				= false;
		private bool					mCheckedRecordTvStation	= false;

		private Thread					mThreadQuerySequence	= null;
		private ManualResetEvent		mSequenceEndFlag		= new ManualResetEvent( false );

		private class Status
		{
			internal bool	busyQueryInfo;				// ԑgf[^擾
		}
		private Status					mStatus					= new Status();
		private System.Windows.Forms.Timer	mUpdateTimer		= null;

		//=========================================================================
		///	<summary>
		///		RXgN^
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public AnimeDialog()
		{
			InitializeComponent();

			mStatus.busyQueryInfo	= false;
		}
		
		//=========================================================================
		///	<summary>
		///		_CAOJ̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		public DialogResult ShowDialog(ref AnimeProgram prog )
		{
			mSyoboCal = AnimeServer.GetInstance().mSyoboiCalender;

			mProgram = prog;

			//-------------------
			// ʍ
			//-------------------
			mLinkOnline = prog.linkOnlineDatabase;
			linkOnlineDatabaseCheckBox.Checked = mLinkOnline;

			//-------------------
			// "ڂ"^u
			//-------------------
			specifyLatestRadio.Checked	= (prog.syobocalPolicy == AnimeProgram.SyobocalPolicy.SpecifyLatest);
			specifyNumberRadio.Checked	= (prog.syobocalPolicy == AnimeProgram.SyobocalPolicy.SpecifyNumber);
			specifyNumberUpdown.Value	= prog.syobocalSpecifyNumber;
			specifyEarlyRadioButton.Checked = (prog.syobocalPolicy == AnimeProgram.SyobocalPolicy.SpecifyEarly);

			//-------------------
			// ""^u
			//-------------------

			if ( !string.IsNullOrEmpty( mProgram.title ) )
			{
				if( mLinkOnline )
					mInputTitle = mProgram.title;
				else
					titleTextBox.Text = mProgram.title;
			}
			storyCountComboBox.Text = string.Format("{0:0}", mProgram.StoryCount);

			mSelectTvStation				= mProgram.syoboiTvStation;
			recordTvStationTextBox.Text		= mProgram.tvStation;
			mCheckedRecordTvStation			= (mProgram.syoboiTvStation != mProgram.tvStation);
			recordTvStationCheckBox.Checked = mCheckedRecordTvStation;

			syoboiTidUpdown.Value = mProgram.syoboiTid;

			//-------------------
			// "^\"^u
			//-------------------
			Scheduler sched = ReserveManager.DefaultScheduler;
			List<string> stations;

			if (sched != null)
			{
				//----------------------------------------
				// ^vOC̃vpeBy[W\
				//----------------------------------------
				if ( sched.ProfilePageType != null )
				{
					mProfilePage = (Scheduler.ProfilePage)Activator.CreateInstance( sched.ProfilePageType );
					mProfilePage.Create( reservePanel );

					mProfilePage.Load( mProgram.SchedulerProfile( sched.ProfileType ) );
				}
			}

			tvStationComboBox_SelectedIndexChanged( null,null );	// y[WTVǃR{

			adjustStartTimeUpdown.Value	= mProgram.adjustStartTime;
			adjustEndTimeUpdown.Value	= mProgram.adjustEndTime;

			//-------------------
			// "GR[h"^u
			//-------------------
			string selectedName = null;

			mCurrentEncoder	= mProgram.EncoderType;
			mCurrentProfile	= mProgram.EncoderProfile;

			mEncoderTable = new Hashtable();
			
			//--------------------------
			// GR[_ꗗ\
			//--------------------------
			foreach (Type encoderType in EncodeManager.EncoderList)
			{
				Encoder encoder;

				encoder = (Encoder)Activator.CreateInstance(encoderType);

				if (mCurrentEncoder == encoderType)
				{
					selectedName = encoder.Name;
				}

				encoderComboBox.Items.Add(encoder.Name);

				mEncoderTable.Add(encoder.Name, encoder);
			}

			if (EncodeManager.EncoderList.Count == 0)
			{
				encodeCheckBox.Enabled = false;
			}else{
				encoderComboBox.SelectedIndex = 0;
				if (selectedName != null)
					encoderComboBox.Text = selectedName;	// ݂̃GR[_I
			}

			if (mProgram.EncoderProfile !=null)				// ăGR[h`FbN{bNX
			{
				encodeCheckBox.Checked = true;
			}


			//-------------------
			// "̑"^u
			//-------------------

			WithoutPowerCheckBox.Checked	= mProgram.WithoutPower;
			filterKeywordCheckBox.Checked	= mProgram.enableFilterKeyword;
			filterKeywordTextBox.Text		= mProgram.filterKeyword;

			// Rg[֑̋XV
			specifyNumberRadio_CheckedChanged(this, null);
			filterKeywordCheckBox_CheckedChanged(this,null);
			recordTvStation_CheckedChanged(this,null);

			try
			{
				PriorityCombobox.SelectedIndex = 4 - ((mProgram.priority - 10) / 10);
			}
			catch(Exception ex)
			{
				PriorityCombobox.SelectedIndex = 2;
			}

			RefreshControl();

			return ShowDialog();
		}

		//=========================================================================
		///	<summary>
		///		[OK]{^̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void okButton_Click(object sender, EventArgs e)
		{
			Cursor oldCursor = Cursor.Current;
			Cursor.Current = Cursors.WaitCursor;
			this.DialogResult	= DialogResult.OK;

			try
			{
				//------------------
				// ""^u
				//------------------

				mProgram.title = titleTextBox.Text;
				if (int.Parse(storyCountComboBox.Text) < 0)
					throw new Exception("p[^sł");
				mProgram.StoryCount = int.Parse(storyCountComboBox.Text);

				mProgram.syoboiTvStation	= syoboiTvStationComboBox.Text;
				if( !mLinkOnline || mLinkOnline && recordTvStationCheckBox.Checked )
					mProgram.tvStation		= recordTvStationTextBox.Text;
				else
					mProgram.tvStation		= syoboiTvStationComboBox.Text;

				//-------------------
				// "ڂ"^u
				//-------------------
				if( specifyLatestRadio.Checked )
					mProgram.syobocalPolicy = AnimeProgram.SyobocalPolicy.SpecifyLatest;
				else if( specifyNumberRadio.Checked )
					mProgram.syobocalPolicy = AnimeProgram.SyobocalPolicy.SpecifyNumber;
				else if( specifyEarlyRadioButton.Checked )
					mProgram.syobocalPolicy = AnimeProgram.SyobocalPolicy.SpecifyEarly;

				mProgram.syobocalSpecifyNumber = (int)specifyNumberUpdown.Value;

				//------------------
				// "^"^u
				//------------------

				if ( mProfilePage != null )
				{
					Scheduler sched = ReserveManager.DefaultScheduler;
					mProfilePage.Save( mProgram.SchedulerProfile( sched.ProfileType ) );
				}

				mProgram.adjustStartTime	= (long)adjustStartTimeUpdown.Value;
				mProgram.adjustEndTime		= (long)adjustEndTimeUpdown.Value;

				//------------------
				// GR[h^u
				//------------------

				mProgram.EncoderType	= mCurrentEncoder;
				if ( mCurrentEncoder != null )
					mProgram.EncoderProfile	= mCurrentProfile;		// ăGR
				else
					mProgram.EncoderProfile = null;					// ăGRȂ

				//------------------
				// 
				//------------------

				mProgram.linkOnlineDatabase	= mLinkOnline;
				mProgram.syoboiTid			= mSelectedTid;

				//------------------
				// ̑
				//------------------

				mProgram.WithoutPower = WithoutPowerCheckBox.Checked;
				mProgram.enableFilterKeyword	= filterKeywordCheckBox.Checked;
				mProgram.filterKeyword			= filterKeywordTextBox.Text;

				if( 0 <= PriorityCombobox.SelectedIndex )
					mProgram.priority			= ((4 - PriorityCombobox.SelectedIndex) + 1) * 10;
				else
					mProgram.priority			= 30;
	
				// ԑg̃f[^XV
				mProgram.UpdatePlan(DateTime.Now);

				Close();

			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.Message, "x", MessageBoxButtons.OK, MessageBoxIcon.Warning);

				this.DialogResult = DialogResult.Cancel;
			}
			finally
			{
				Cursor.Current = oldCursor;
			}

		}
		
		//=========================================================================
		///	<summary>
		///		ICDBƘA`FbN{bNX̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void linkOnlineDatabaseCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			mLinkOnline = linkOnlineDatabaseCheckBox.Checked;

			RefreshControl();
		}

		//=========================================================================
		///	<summary>
		///		ăGR[h`FbN{bNX̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void encodeCheckBox_CheckedChanged_1(object sender, EventArgs e)
		{
			encoderComboBox_SelectedIndexChanged(sender,e);

			RefreshControl();
		}

		//=========================================================================
		///	<summary>
		///		GR[_IR{{bNXύXꂽƂ̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void encoderComboBox_SelectedIndexChanged(object sender, EventArgs e)
		{
			Encoder encoder = null;

			if (encodeCheckBox.Checked)
				encoder = (Encoder)mEncoderTable[encoderComboBox.Text];

			if (mEncoderForm != null)
			{
				//
				// GR[_IOꂽvpeBy[W폜
				//
				mEncoderForm.Close();

				mCurrentEncoder = null;
			}

			if (encoder != null)
			{
				//--------------------------------------------
				// IꂽGR[_̃vpeBy[W쐬
				//--------------------------------------------
				mCurrentEncoder = encoder.GetType();

				if (mCurrentEncoder == mProgram.EncoderType &&
					mProgram.EncoderProfile != null)
				{
					mCurrentProfile = mProgram.EncoderProfile;
				}
				else
				{
					//-------------------------------------
					// IGR[_̃vt@C쐬
					//-------------------------------------
					mCurrentProfile = (EncodeProfile)Activator.CreateInstance(encoder.ProfileType);
				}

				//------------------------------
				// vt@Cݒy[W\
				//------------------------------
				mEncoderForm = encoder.CreatePropertyPage(
								encoderPanel	,
								mCurrentProfile	);

			}
			else {
				mEncoderForm = null;
			}

		}

		//=========================================================================
		///	<summary>
		///		[ԑgꗗ]{^̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void syoboiListButton_Click(object sender, EventArgs e)
		{
			SyoboiListDlg dlg = new SyoboiListDlg();

			if (dlg.ShowDialog() == DialogResult.OK)
			{
				syoboiTidUpdown.Value = dlg.tid;
			}

		}

		//=========================================================================
		///	<summary>
		///		ڂTIDύXꂽ̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void syoboiTidUpdown_ValueChanged(object sender, EventArgs e)
		{
			mZappingTid = (int)syoboiTidUpdown.Value;
		}

		//=========================================================================
		///	<summary>
		///		ԑgy[W̎erǃR{ύX̏
		///	</summary>
		/// <remarks>
		///		uerǁv͎ɂڂf[^QƂ邽߂̃erǖB
		///		u^erǁv͘^\tgɓn߂̃erǖB
		/// </remarks>
		/// <history>2006/XX/XX VK쐬</history>
		//=========================================================================
		private void tvStationComboBox_SelectedIndexChanged(object sender, EventArgs e)
		{
			// ^erǖeLXg{bNXɑ
			if( mLinkOnline && !recordTvStationCheckBox.Checked )
				recordTvStationTextBox.Text = syoboiTvStationComboBox.Text;
		}

		private void registCheckBox_CheckedChanged(object sender, EventArgs e)
		{
		}

		private void specifyNumberRadio_CheckedChanged(object sender, EventArgs e)
		{
			specifyNumberUpdown.Enabled = specifyNumberRadio.Checked;
		}

		private void filterKeywordCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			filterKeywordTextBox.Enabled = filterKeywordCheckBox.Checked;
		}

		private void recordTvStation_CheckedChanged(object sender, EventArgs e)
		{
			mCheckedRecordTvStation = recordTvStationCheckBox.Checked;
			RefreshControl();
		}

		private void recordTvStationTextBox_TextChanged(object sender, EventArgs e)
		{
		}

		//=========================================================================
		///	<summary>
		///		ICԑg̎擾V[PX(񓯊)
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2009/10/18 VK쐬</history>
		//=========================================================================
		delegate void LetProgramInformation();
		private void DoQueryInfoSequence()
		{
            for (; ; )
			{
                if (mSequenceEndFlag.WaitOne( 0, false ))
                    break;

// <PENDING> 2009/11/24 zfXNgbv\tgEBhE΍ ->
				if( !this.Visible )
					break;
// <PENDING> 2009/11/24 <-

				if( mZappingTid != mSelectedTid && mLinkOnline )
				{
					List<SyoboiCalender.SyoboiRecord>	recordList		= null; 
					ArrayList							tvStationList	= null;

                    lock (mStatus) { mStatus.busyQueryInfo = true; }

					//-----------------------------------
					// Iꂽԑg̕ǈꗗXV
					//-----------------------------------
					try
					{
						string title = "";

						LetProgramInformation setWaitingMsg = delegate() { syoboiTitleTextBox.Text = "(f[^擾)"; };
						this.Invoke(setWaitingMsg);

						// ԑgf[^擾
						if (0 < mZappingTid)
						{
							mSelectedTid = mZappingTid;

							recordList		= mSyoboCal.DownloadOnAirList(mSelectedTid, out title);
							tvStationList	= mSyoboCal.ListupTvStation(recordList);
						}

						// ԑgf[^ʂɃZbg
						LetProgramInformation proc = delegate()
						{
							syoboiTvStationComboBox.Items.Clear();
							syoboiTvStationComboBox.Items.Add("(wȂ)");
							syoboiTvStationComboBox.SelectedIndex = 0;

							if( 0 < mZappingTid )
							{
								syoboiTitleTextBox.Text	= title;
								titleTextBox.Text		= title;

								foreach (string tvStation in tvStationList)
									syoboiTvStationComboBox.Items.Add(tvStation);

								if (mSelectTvStation != null)
								{
									syoboiTvStationComboBox.Text = mSelectTvStation;
									mSelectTvStation = null;
								}

                                // b\
                                int maxNumber = 0;

                                foreach (SyoboiCalender.SyoboiRecord record in recordList)
                                    maxNumber = System.Math.Max(maxNumber, record.number);

								storyCountComboBox.Text = Convert.ToString(maxNumber);

								if (mInputTitle != null)
								{
									titleTextBox.Text = mInputTitle;
                                    mInputTitle = null;
								}
							}
						};

                        this.Invoke(proc);

					}
					catch (Exception x)
					{
//						Program.ShowException(x, MessageBoxIcon.Error);
					}

					lock (mStatus) { mStatus.busyQueryInfo = false; }
				}

				Thread.Sleep( 200 );
			}
		}

		//=========================================================================
		///	<summary>
		///		_CAO鎞̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2009/10/18 VK쐬</history>
		//=========================================================================
		private void AnimeDialog_FormClosed(object sender, FormClosedEventArgs e)
		{
			mSequenceEndFlag.Set();
			mThreadQuerySequence = null;
		}

		//=========================================================================
		///	<summary>
		///		_CAO\ۂ̏
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2009/10/18 VK쐬</history>
		//=========================================================================
		private void AnimeDialog_Shown(object sender, EventArgs e)
		{
			if (mThreadQuerySequence == null)
			{
                mThreadQuerySequence = new Thread(new ThreadStart(DoQueryInfoSequence));
                mThreadQuerySequence.Start();
            }

			if (mUpdateTimer == null)
			{
				mUpdateTimer = new System.Windows.Forms.Timer();
                mUpdateTimer.Tick += new EventHandler(OnUpdateTimer);
                mUpdateTimer.Interval = 100;
				mUpdateTimer.Start();
            }
        }

		//=========================================================================
		///	<summary>
		///		\XV
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2009/10/18 VK쐬</history>
		//=========================================================================
		private void OnUpdateTimer(object sender, EventArgs args)
		{
			RefreshControl();
		}

		//=========================================================================
		///	<summary>
		///		erǖϊe[uʂJ
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2010/03/28 VK쐬</history>
		//=========================================================================
		private void stationTableButton_Click(object sender, EventArgs e)
		{
			StationTableDialog	dlg;
			string				stationName;

			if( recordTvStationCheckBox.Checked )
				stationName = recordTvStationTextBox.Text;
            else
                if( 0 < syoboiTvStationComboBox.SelectedIndex )
					stationName = syoboiTvStationComboBox.Text;
				else
					return;

			dlg = new StationTableDialog(stationName);

			dlg.ShowDialog();
		}

		//=========================================================================
		///	<summary>
		///		Rg[̏ԍXV
		///	</summary>
		/// <remarks>
		/// </remarks>
		/// <history>2010/05/03 VK쐬</history>
		//=========================================================================
		private void RefreshControl()
		{
			okButton.Enabled				= !mStatus.busyQueryInfo;
			syoboiTvStationComboBox.Enabled = !mStatus.busyQueryInfo && mLinkOnline;
			storyCountComboBox.Enabled		= !mStatus.busyQueryInfo;
			titleTextBox.Enabled			= !mStatus.busyQueryInfo;
			stationTableButton.Enabled		= !mStatus.busyQueryInfo;

//			waitingLabel.Visible			= mStatus.busyQueryInfo;
			encoderGroup.Enabled			= encodeCheckBox.Checked;
			recordTvStationTextBox.Enabled	= (mLinkOnline && mCheckedRecordTvStation) || !mLinkOnline;
			recordTvStationCheckBox.Enabled	= mLinkOnline;
		}

        //=========================================================================
        ///	<summary>
        ///		ڃJJ
        ///	</summary>
        /// <remarks>
        /// </remarks>
        /// <history>2012/03/19 VK쐬</history>
        //=========================================================================
        private void linkLabel2_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            int tid  = (int)syoboiTidUpdown.Value;
            if (tid != 0)
            {
                System.Diagnostics.Process.Start("http://cal.syoboi.jp/tid/" + tid.ToString());
            }
            else
            {
                System.Diagnostics.Process.Start("http://cal.syoboi.jp/");
            }
        }

	}

}

