package com.jm;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.view.View;

import com.jm.utility.Graphics;
import com.jm.utility.Resource;

public class JugglerCanvas extends View {
	private static final int DENOMINATOR = 1000;
// edit
//	private static final int MAX_N_BALL = 35;

	public static final int color[] = {
		0x0000ff, 0xff0000, 0xffff00, 0x00ff00, 0xffa000, 0xa0522d,
		0xff7f2b, 0x87ceeb, 0xb03060, 0xffc0cb, 0xff00ff, 0xa020f0, 0x00ffff};

// edit {	
//	private Image[]		ballImage;
//	private Image		image;
	private int diameter;
// }
	private Graphics	graphics;
	private int			center;
	private int			base = 60;
	private int			magnification = 400;
	private int			ssHeight;

	private JmPattern jp;
	private Juggler handler;
	private JugglingBalls balls;
	
	// edit ̃^C~O
	private long counter = -1;

	public JugglerCanvas(Context c, int index1, int index2) {
        super(c);
        setFocusable(true);

       graphics = Graphics.getInstance();
       PatternList patternList = new PatternList(null, index1);
       jp = patternList.get(index2);        
       handler = new Juggler(this, 8);
       handler.start(jp);
    }

	public void setBalls(JugglingBalls balls) {
		this.balls = balls;
	}

	protected void onDrawInit(Canvas canvas) {
		center = getWidth() / 2;
// edit {
//		image = Image.createImage(getWidth(), getHeight());
//		graphics = image.getGraphics();
// }
		graphics.translate(center, 0);
// edit {
//		graphics.setFont(Resource.SITESWAP_FONT);
//		graphics.setColor(Resource.getBackgroundColor());
// }
		graphics.fillRect(-center, 0, getWidth(), getHeight()); 
		ssHeight = Resource.charHeight() + 2;
		clear();
		
		this.setImageHeight(balls.getYRange());
		this.createBalls(handler.getSiteSwap().getNumberOfBalls());
		graphics.setCanvas(canvas);
	}
	
	protected void onDraw(Canvas canvas) {
// edit {
		if (counter < 0){
			onDrawInit(canvas);
			counter = 0;
		}
// }
		if (handler.isPlaying()) {
			
	        Paint paint = new Paint();
			paint.setStyle(Paint.Style.FILL);
	        paint.setColor(Color.WHITE);
			canvas.drawRect(0, 0, this.getWidth(), getHeight(), paint);
			
			handler.drawJuggler(counter);
// edit
//			this.repaint();
			counter++;
		}
	   
	}
	
	public void setForegroundColor() {
// edit {
//		graphics.setColor(Resource.getForegroundColor());
// }
	}
	
	public void setBackgroundColor() {
// edit {
//		graphics.setColor(Resource.getBackgroundColor());
// }
	}
	
	public void setEmphasisColor() {
// edit {
//		graphics.setColor(Resource.getEmphasisColor());
// }
	}

	/*********************************************************************
	 *********************************************************************/
	void setImageHeight(int yrange) {
		magnification = DENOMINATOR;
		int height = getHeight() - ssHeight;
		if (yrange > 0) {
			magnification = magnification * height / yrange;
		}
		base = (int)(getHeight() - 55 * magnification / DENOMINATOR);
	}

	/*********************************************************************
	 *********************************************************************/
	public void createBalls(int number) {
// edit {
//		int diameter = translateR(Ball.RADIUS) * 2;
//		if (diameter < 2) diameter = 2;
//		ballImage = new Image[number % color.length];
//		for (int i = 0; i < ballImage.length; i++){
//			ballImage[i] = Image.createImage(diameter, diameter);
//			Graphics g = ballImage[i].getGraphics();
//			g.setColor(Resource.getBackgroundColor());
//			g.fillRect(0, 0, diameter, diameter);
//			g.setColor(color[i]);
//			g.fillArc(0, 0, diameter, diameter, 0, 360);
//		}
		diameter = translateR(Ball.RADIUS) * 2;
		if (diameter < 2) diameter = 2;
// }
	}

	/*********************************************************************
	 *********************************************************************/
	protected void paint(int i, Graphics g) {
// edit {
//		g.drawImage(image, 0, 0, Graphics.TOP|Graphics.LEFT);
// }
	}

	/*********************************************************************
	 *********************************************************************/
	public void clear() {
		setBackgroundColor();
		graphics.fillRect(-center, ssHeight, getWidth(), getHeight()); 
		setForegroundColor();
	}

	/*********************************************************************
	 *********************************************************************/
// edit {
//	public void drawImage(Image image, int x, int y, int anchor) {
//		graphics.drawImage(image, x, y, anchor);
//	}
// }
	
	/*********************************************************************
	 *********************************************************************/
	public void drawBall(int i, int x, int y) {
		x = translateX(x);
		y = translateY(y);
// edit {
//		drawImage(ballImage[i % ballImage.length], x, y, Graphics.VCENTER|Graphics.HCENTER);
		graphics.drawImage(i, x, y, diameter / 2);
// }
	}

	/*********************************************************************
	 *********************************************************************/
	public void drawLine(int x1, int y1, int x2, int y2) {
		x1 = translateX(x1);
		y1 = translateY(y1);
		x2 = translateX(x2);
		y2 = translateY(y2);
		graphics.drawLine(x1, y1, x2, y2);
	}

	/*********************************************************************
	 *********************************************************************/
	public void drawCircle(int x, int y, int r) {
		x = translateX(x);
		y = translateY(y);
		r = translateR(r);
		// edit
		//graphics.drawArc(x - r, y - r, 2 * r, 2 * r, 0, 360);
		graphics.drawCircle(x, y, r);
	}
	
	/*********************************************************************
	 *********************************************************************/
	public void drawString(String str, int x, int y, int anchor, int color) {
		graphics.drawString(str, x, y, anchor, color);
	}

	/*********************************************************************
	 *********************************************************************/
	private int translateX(int x) {
		if (JmPattern.ifMirror()) x = -x;
		return translate(x);
	}

	private int translateY(int y) {
		return translate(y) + base;
	}
	
	private int translateR(int r) {
		return translate(r);
	}
	private int translate(int t) {
		return t * magnification / DENOMINATOR;
	}
}
