package com.jm;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemLongClickListener;

import com.jm.db.Dao;
import com.jm.utility.BaseActivity;
import com.jm.utility.JmException;

public class Menu2 extends BaseActivity {
	private int index = -1;
	private ListView listView = null;
	private JmPattern[] list = null;
	
    @Override
	protected void onRestart() {
		super.onRestart();
		if (index >= 0) {
			try {
				list = Dao.getInstance().get(index);
				ArrayAdapter<JmPattern> adapter = new ArrayAdapter<JmPattern>(
						this, android.R.layout.simple_list_item_1, list);
				listView.setAdapter(adapter);
			} catch (JmException e) {
				showDialog();
			}
		}
	}

	public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.menu2);

	    Bundle extras = getIntent().getExtras();
	    index = extras.getInt("INDEX");
// todo {
//	    PatternList patternList = new PatternList(null, index);

// }// todo {
//	    CharSequence[] list = new CharSequence[patternList.size()];
//	    for (int i = 0; i < patternList.size(); i++){
//	    	JmPattern pattern = patternList.get(i);
//	    	list[i] = pattern.getName();
//	    }
	    try {
	    	list = Dao.getInstance().get(index);
	    }
	    catch (JmException e){
	    	showDialog();	    	
	    	return;
	    }
// }
	    
		listView = (ListView)findViewById(R.id.Menu2);
		ArrayAdapter<JmPattern> adapter = new ArrayAdapter<JmPattern>(this, android.R.layout.simple_list_item_1, list);
		listView.setAdapter(adapter);

		listView.setOnItemClickListener(new OnItemClickListener() {
			@Override
			public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
				if (index == 6 && position == 0){
					Intent intent = new Intent(Menu2.this, (Class<?>)Edit.class);
					intent.putExtra("MODE", Edit.NEW);
					intent.putExtra("ID", list[position].getId());
					startActivityForResult(intent, -1);				
				}
				else {
					Intent intent = new Intent(Menu2.this, (Class<?>)JuggleView.class);
					intent.putExtra("INDEX1", index);
					intent.putExtra("INDEX2", position);
					intent.putExtra("ID", list[position].getId());
					startActivityForResult(intent, -1);
				}
			}			
		});
		
		listView.setOnItemLongClickListener(new OnItemLongClickListener(){
			@Override
			public boolean onItemLongClick(AdapterView<?> arg0, View arg1,
					int position, long arg3) {
				if (index == 6 && position == 0){
					return false;
				}
				Intent intent = new Intent(Menu2.this, (Class<?>)Edit.class);
				intent.putExtra("MODE", Edit.EDIT);
				intent.putExtra("INDEX1", index);
				intent.putExtra("ID", list[position].getId());
				startActivityForResult(intent, -1);				
				return true;
			}
		});
    }
}
