<?php

function assignGlobalValues( & $smarty ){

	// site_config
	$ddo  = DB_DataObject::factory(TABLE_PREFIX.'site_config');
	$ddo->find();
	if($ddo->fetch()){
		$smarty->assign('site_config', $ddo->toArray());
	}
	$ddo->free();

	$smarty->assign('URL_BASE',    URL_BASE);
	$smarty->assign('URL_HOME',    URL_HOME);
	$smarty->assign('URL_UPIMAGE', URL_UPIMAGE);
}

function assignTagTables( & $smarty ){

	$categorytbl = array();
	$roletbl  = array();
	$techtbl  = array();

	// tag,career
	$tagddo    = DB_DataObject::factory(TABLE_PREFIX.'tag');
	$careerddo = DB_DataObject::factory(TABLE_PREFIX.'career');
	$tagddo->joinAdd($careerddo,'INNER','t');
	$tagddo->selectAdd( 'sum(t.working_weeks) sum_working_weeks' );	
	$tagddo->selectAdd('count(*) cnt');
	//$tagddo->owner_name ='sdcm_career.roletagwords';
	$tagddo->groupBy( 'word,owner_name' );
	$tagddo->orderby('cnt desc, sum_working_weeks desc');
	$tagddo->find();
	$roletagtbl = array();
	while( $tagddo->fetch() ){
	    $item     = $tagddo->toArray();
		$item['word_rawurlencode'] = rawurlencode( $item['word'] );

		if($item['owner_name'] == TABLE_PREFIX.'career.category' ){
			$categorytbl[] = $item;
		} else if( $item['owner_name'] == TABLE_PREFIX.'career.role' ){
			$roletbl[] = $item;
		} else if( $item['owner_name'] == TABLE_PREFIX.'career.tech' ){
			$techtbl[] = $item;
		}
	}
	$tagddo->free();

	$smarty->assign( 'categorytagtbl', $categorytbl );
	$smarty->assign( 'roletagtbl',     $roletbl );
	$smarty->assign( 'techtagtbl',     $techtbl );
	
	return;
}



function getRoleTagTable(){
	// tag
	$tagddo    = DB_DataObject::factory(TABLE_PREFIX.'tag');
	$tagddo->selectAdd('count(*) cnt');
	$tagddo->owner_name ='sdcm_career.roletagwords';
	$tagddo->groupBy( 'word' );
	$tagddo->find();
	$roletagtbl = array();
	while( $tagddo->fetch() ){
	    $item     = $tagddo->toArray();
		$item['word_rawurlencode'] = rawurlencode( $item['word'] );
		$roletagtbl[] = $item;
	}
	$tagddo->free();
	return $roletagtbl;
}

function getTechTagTable(){

	// tag
	$tagddo    = DB_DataObject::factory(TABLE_PREFIX.'tag');
	$tagddo->selectAdd('count(*) cnt');
	$tagddo->owner_name ='sdcm_career.techtagwords';
	$tagddo->groupBy( 'word' );
	$tagddo->find();
	$techtagtbl = array();
	while( $tagddo->fetch() ){
	    $item     = $tagddo->toArray();
		$item['word_rawurlencode'] = rawurlencode( $item['word'] );
		$techtagtbl[] = $item;
	}
	$tagddo->free();

	return $techtagtbl;
}
?>