<?php
/********************************************************************************
 * SdClient.class.php
 * 
 * $Id: SdClient.class.php,v 1.1 2005/11/03 18:00:11 junneko Exp $
 ********************************************************************************/

require_once 'HTTP/Request.php';

class SdClient {

	function SdClient($server){
		
		$this->_server  = $server;
		$this->_request = & new HTTP_Request();
	
	}

	function login( $account,$password ){
		$url = 'login.php';
		$params = array( 'mode'=>'login', "email"=>$account,"password"=>$password );
		$ret = $this->sendRequest($url,HTTP_REQUEST_METHOD_POST,$params);

		if( PEAR::isError( $ret )){
			return $ret;
		}

		// TODO junneko ޤʤ
		$cookies = $this->_request->getResponseCookies();

		if( ! is_array($cookies)){
			return false;
		}
		
		$_SESSION[$this->_server]['cookies'] = $cookies;
		
		return false;
	}
	
	function logout(){
		$_SESSION[$this->_server] = null;
	}
	
	function isLogin(){

		if( ! is_array($_SESSION[$this->_server]['cookies'])){
			return false;
		}
		return true;
	}
	
	function sendRequest($uri,$method,$params){
			
			$url = $this->_server.$uri;
			
			$req = & $this->_request;
			$req->setMethod($method);
			$req->setURL($url);
			$req->clearPostData();
			
			if( (!is_null($params)) && is_array( $params )){
				foreach( $params as $k=>$v ){
					$req->addPostData( $k, $v );
				}
			}
			
			$cookies = $_SESSION[$this->_server]['cookies'];
			if( is_array( $cookies )){
				foreach ($cookies as $cookie) {
					$req->addCookie($cookie['name'], $cookie['value']);
				}
			}
			$ret = $req->sendRequest();
			if( PEAR::isError( $ret )){
				return $ret;
			}

			return $req->getResponseBody();	
	}
}

?>