/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.extension.jdbc.ResultSetFactory;

public class DaoMetaDataFactory {
    private Map daoMetaDataCache_ = new HashMap();
    private DataSource dataSource_;
    private ResultSetFactory resultSetFactory_;

    public DaoMetaDataFactory(DataSource dataSource, ResultSetFactory resultSetFactory) {
        this.dataSource_ = dataSource;
        this.resultSetFactory_ = resultSetFactory;
    }

    public DaoMetaData getDaoMetaData(Class daoClass) {
        String key = daoClass.getName();
        DaoMetaData dmd = (DaoMetaData)this.daoMetaDataCache_.get(key);
        if (dmd != null) {
            return dmd;
        }
        DaoMetaDataFactory daoMetaDataFactory = this;
        synchronized (daoMetaDataFactory) {
            dmd = (DaoMetaData)this.daoMetaDataCache_.get(key);
            if (dmd != null) {
                return dmd;
            }
            dmd = new DaoMetaDataImpl(daoClass, this.dataSource_, this.resultSetFactory_);
            this.daoMetaDataCache_.put(key, dmd);
        }
        return dmd;
    }
}

