package org.seasar.dao.interceptors;

import java.lang.reflect.Method;

import javax.sql.DataSource;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.DaoMetaDataFactory;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.util.MethodUtil;

/**
 * @author higa
 *  
 */
public class S2DaoInterceptor extends AbstractInterceptor {

	private DataSource dataSource_;

	private DaoMetaDataFactory daoMetaDataFactory_;

	public S2DaoInterceptor(DataSource dataSource,
			ResultSetFactory resultSetFactory) {

		dataSource_ = dataSource;
		daoMetaDataFactory_ = new DaoMetaDataFactory(dataSource,
				resultSetFactory);
	}

	/**
	 * @see org.aopalliance.intercept.MethodInterceptor#invoke(org.aopalliance.intercept.MethodInvocation)
	 */
	public Object invoke(MethodInvocation invocation) throws Throwable {
		Method method = invocation.getMethod();
		if (!MethodUtil.isAbstract(method)) {
			return invocation.proceed();
		}
		Class daoClass = getTargetClass(invocation);
		DaoMetaData dmd = daoMetaDataFactory_.getDaoMetaData(daoClass);
		SqlCommand cmd = dmd.getSqlCommand(method.getName());
		return cmd.execute(invocation.getArguments());
	}
}