/*
 * 쐬F 2004/08/20
 */
package org.seasar.tapestry.engine;

import org.apache.tapestry.IEngine;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IMonitor;
import org.apache.tapestry.pageload.PageLoader;
import org.apache.tapestry.pageload.PageSource;
import org.seasar.tapestry.util.BeanCopy;

/**
 * @author maruo_syunsuke
 */
public class S2PageSource extends PageSource {
	/**
	 * @param engine
	 */
	public S2PageSource(IEngine engine) {
		super(engine);
	}

	protected S2PageLoader createPageLoader(IRequestCycle cycle) {
		return new S2PageLoader(cycle);
	}

	protected PageLoader getPageLoader(IRequestCycle cycle) {
		PageLoader result = (PageLoader) cycle.getEngine().getPool().retrieve(
				PageLoader.class.getName());

		if (result == null)
			result = createPageLoader(cycle);

		return result;
	}
	
	/* (non-Javadoc)
	 * @see org.apache.tapestry.engine.IPageSource#getPage(org.apache.tapestry.IRequestCycle, java.lang.String, org.apache.tapestry.engine.IMonitor)
	 */
	public IPage getPage(IRequestCycle cycle, String pageName, IMonitor monitor) {
		IPage now = cycle.getPage();
		IPage next = super.getPage(cycle,pageName,monitor);
		if( now != null ){
			BeanCopy copy = new BeanCopy();
			copy.beanCopy(next, now);
		}
		return next ;
	}
}