package org.seasar.dao.impl;

import javax.sql.DataSource;

import org.seasar.dao.CommandContext;
import org.seasar.dao.Node;
import org.seasar.dao.context.CommandContextImpl;
import org.seasar.dao.parser.SqlParserImpl;

/**
 * @author higa
 *  
 */
public abstract class AbstractDynamicCommand extends AbstractSqlCommand {

	private Node rootNode_;

	private String[] argNames_ = new String[0];

	public AbstractDynamicCommand(DataSource dataSource) {
		super(dataSource);
	}

	public void setSql(String sql) {
		super.setSql(sql);
		rootNode_ = new SqlParserImpl(sql).parse();
	}

	public String[] getArgNames() {
		return argNames_;
	}

	public void setArgNames(String[] argNames) {
		argNames_ = argNames;
	}

	protected CommandContext apply(Object[] args) {
		CommandContext ctx = createCommandContext(args);
		rootNode_.accept(ctx);
		return ctx;
	}

	protected CommandContext createCommandContext(Object[] args) {
		CommandContext ctx = new CommandContextImpl();
		if (args != null) {
			for (int i = 0; i < args.length; ++i) {
				if (i < argNames_.length) {
					ctx.addArg(argNames_[i], args[i]);
				} else {
					ctx.addArg("$" + (i + 1), args[i]);
				}
			}
		}
		return ctx;
	}
}