package org.seasar.dao.impl;

import javax.sql.DataSource;

import org.seasar.dao.BeanMetaData;
import org.seasar.dao.IdentifierGenerator;

/**
 * @author higa
 *  
 */
public class InsertAutoHandler extends AbstractAutoHandler {

	public InsertAutoHandler(DataSource dataSource, BeanMetaData beanMetaData) {
		super(dataSource, beanMetaData);
	}

	protected void setupSql() {
		setSql(getBeanMetaData().getAutoInsertSql());
	}

	protected Object[] getBindVariables(Object bean) {
		return getBeanMetaData().getAutoInsertBindVariables(bean);
	}
	
	protected void preUpdateBean(Object bean) {
		IdentifierGenerator generator = getBeanMetaData().getIdentifierGenerator();
		if (generator.isSelfGererate()) {
			generator.setIdentifier(bean, getDataSource());
		}
	}
	
	protected void postUpdateBean(Object bean, Object[] bindVariables) {
		IdentifierGenerator generator = getBeanMetaData().getIdentifierGenerator();
		if (!generator.isSelfGererate()) {
			generator.setIdentifier(bean, getDataSource());
		}
	}
}