package test.org.seasar.dao.impl;

import org.seasar.dao.DaoMetaData;
import org.seasar.dao.UpdateFailureRuntimeException;
import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.SelectDynamicCommand;
import org.seasar.dao.impl.UpdateAutoStaticCommand;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.extension.jdbc.impl.BasicResultSetFactory;

public class UpdateAutoStaticCommandTest extends S2DaoTestCase {

	public UpdateAutoStaticCommandTest(String arg0) {
		super(arg0);
	}

	public void testExecuteTx() throws Exception {
		UpdateAutoStaticCommand cmd = new UpdateAutoStaticCommand(
				getDataSource(), new BeanMetaDataImpl(Employee.class,
						getDatabaseMetaData(), getDbms()));
		DaoMetaData dmd = new DaoMetaDataImpl(EmployeeAutoDao.class,
				getDataSource(), BasicResultSetFactory.INSTANCE);
		SelectDynamicCommand cmd2 = (SelectDynamicCommand) dmd
				.getSqlCommand("getEmployee");
		Employee emp = (Employee) cmd2.execute(new Object[]{new Integer(7788)});
		Integer count = (Integer) cmd.execute(new Object[] { emp });
		assertEquals("1", new Integer(1), count);
	}

	public void testExecute2Tx() throws Exception {
		UpdateAutoStaticCommand cmd = new UpdateAutoStaticCommand(
				getDataSource(), new BeanMetaDataImpl(Department.class,
						getDatabaseMetaData(), getDbms()));
		Department dept = new Department();
		dept.setDeptno(10);
		Integer count = (Integer) cmd.execute(new Object[] { dept });
		assertEquals("1", new Integer(1), count);
		assertEquals("2", 1, dept.getVersionNo());
	}

	public void testExecute3Tx() throws Exception {
		UpdateAutoStaticCommand cmd = new UpdateAutoStaticCommand(
				getDataSource(), new BeanMetaDataImpl(Department.class,
						getDatabaseMetaData(), getDbms()));
		Department dept = new Department();
		dept.setDeptno(10);
		dept.setVersionNo(-1);
		try {
			cmd.execute(new Object[] { dept });
			fail("1");
		} catch (UpdateFailureRuntimeException ex) {
			System.out.println(ex);
		}
	}

	public void setUp() {
		include("j2ee.dicon");
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(UpdateAutoStaticCommandTest.class);
	}

}