package test.org.seasar.dao.unit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import org.seasar.dao.unit.S2DaoBeanListReader;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.unit.S2TestCase;

import test.org.seasar.dao.impl.Department;
import test.org.seasar.dao.impl.Employee;

/**
 * @author higa
 *  
 */
public class S2DaoBeanListReaderTest extends S2TestCase {

	/**
	 * Constructor for InvocationImplTest.
	 * 
	 * @param arg0
	 */
	public S2DaoBeanListReaderTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(S2DaoBeanListReaderTest.class);
	}

	protected void setUp() throws Exception {
		include("j2ee.dicon");
	}

	public void testRead() throws Exception {
		Employee emp = new Employee();
		emp.setEmpno(7788);
		emp.setEname("SCOTT");
		emp.setDeptno(10);
		Department dept = new Department();
		dept.setDeptno(10);
		dept.setDname("HOGE");
		emp.setDepartment(dept);
		List list = new ArrayList();
		list.add(emp);
		S2DaoBeanListReader reader = new S2DaoBeanListReader(list,
				getDatabaseMetaData());
		DataSet ds = reader.read();
		DataTable table = ds.getTable(0);
		DataRow row = table.getRow(0);
		assertEquals("1", new BigDecimal(7788), row.getValue("empno"));
		assertEquals("2", "SCOTT", row.getValue("ename"));
		assertEquals("3", new BigDecimal(10), row.getValue("deptno"));
		assertEquals("4", "HOGE", row.getValue("dname_0"));
	}
}