/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.util;

import java.lang.reflect.Field;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.FieldUtil;
import org.seasar.jsf.util.BindingUtil;

public class MethodBindingUtil {
    private static final String EXPORT_SUFFIX = "_EXPORT";
    private static final String SESSION = "session";

    private MethodBindingUtil() {
    }

    public static String invoke(MethodBinding mb, FacesContext context) {
        String fromAction = mb.getExpressionString();
        String componentName = MethodBindingUtil.getComponentName(fromAction);
        S2Container container = SingletonS2ContainerFactory.getContainer();
        Object component = null;
        BeanDesc beanDesc = null;
        if (componentName != null && container.hasComponentDef((Object)componentName)) {
            ComponentDef cd = container.getComponentDef((Object)componentName);
            component = cd.getComponent();
            beanDesc = BeanDescFactory.getBeanDesc((Class)cd.getComponentClass());
        }
        if (component != null) {
            MethodBindingUtil.importVariables(component, container, beanDesc);
        }
        String outcome = MethodBindingUtil.invokeInternal(mb, context);
        if (component != null) {
            MethodBindingUtil.exportVariables(component, container, beanDesc);
        }
        return outcome;
    }

    private static String getComponentName(String fromAction) {
        if (fromAction == null) {
            return null;
        }
        int index = fromAction.indexOf(46);
        if (index > 0) {
            return fromAction.substring(2, index);
        }
        return null;
    }

    private static String invokeInternal(MethodBinding mb, FacesContext context) {
        try {
            return (String)mb.invoke(context, null);
        }
        catch (EvaluationException ex) {
            Throwable cause = ex.getCause();
            if (cause != null && cause instanceof AbortProcessingException) {
                throw (AbortProcessingException)cause;
            }
            throw ex;
        }
    }

    private static void importVariables(Object component, S2Container container, BeanDesc beanDesc) {
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            Object var;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (pd.hasWriteMethod() && (var = BindingUtil.getValue(container, pd.getPropertyName())) != null) {
                pd.setValue(component, var);
            }
            ++i;
        }
    }

    private static void exportVariables(Object component, S2Container container, BeanDesc beanDesc) {
        int i = 0;
        while (i < beanDesc.getPropertyDescSize()) {
            Object var;
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (pd.hasReadMethod() && (var = pd.getValue(component)) != null) {
                Field field;
                String value;
                boolean useSession = false;
                String fieldName = String.valueOf(pd.getPropertyName()) + EXPORT_SUFFIX;
                if (beanDesc.hasField(fieldName) && SESSION.equalsIgnoreCase(value = (String)FieldUtil.get((Field)(field = beanDesc.getField(fieldName)), null))) {
                    useSession = true;
                }
                if (useSession) {
                    container.getSession().setAttribute(pd.getPropertyName(), var);
                } else {
                    container.getRequest().setAttribute(pd.getPropertyName(), var);
                }
            }
            ++i;
        }
    }
}

