/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.util.ExtensionsResponseWrapper;

public class AddResource {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$component$html$util$AddResource == null ? (class$org$apache$myfaces$component$html$util$AddResource = AddResource.class$("org.apache.myfaces.component.html.util.AddResource")) : class$org$apache$myfaces$component$html$util$AddResource));
    private static final String COMPONENTS_PACKAGE = "org.apache.myfaces.custom.";
    private static final String RESOURCE_VIRUAL_PATH = "/faces/myFacesExtensionResource";
    private static final String ADDITIONAL_HEADER_INFO_REQUEST_ATTRUBITE_NAME = "myFacesHeaderResource2Render";
    static /* synthetic */ Class class$org$apache$myfaces$component$html$util$AddResource;

    public static void addJavaScriptHere(Class componentClass, String resourceFileName, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", "text/javascript", null);
        writer.writeURIAttribute("src", AddResource.getResourceMappedPath(componentClass, resourceFileName, context), null);
        writer.endElement("script");
    }

    public static void addJavaScriptToHeader(Class componentClass, String resourceFileName, FacesContext context) {
        AddResource.addJavaScriptToHeader(componentClass, resourceFileName, false, context);
    }

    public static void addJavaScriptToHeader(Class componentClass, String resourceFileName, boolean defer, FacesContext context) {
        AdditionalHeaderInfoToRender jsInfo = new AdditionalHeaderInfoToRender(0, componentClass, resourceFileName, defer);
        AddResource.addAdditionalHeaderInfoToRender(context, jsInfo);
    }

    public static void addStyleSheet(Class componentClass, String resourceFileName, FacesContext context) {
        AdditionalHeaderInfoToRender cssInfo = new AdditionalHeaderInfoToRender(1, componentClass, resourceFileName);
        AddResource.addAdditionalHeaderInfoToRender(context, cssInfo);
    }

    public static void addInlineStyleToHeader(String inlineStyle, FacesContext context) {
        AdditionalHeaderInfoToRender cssInfo = new AdditionalHeaderInfoToRender(2, inlineStyle);
        AddResource.addAdditionalHeaderInfoToRender(context, cssInfo);
    }

    public static String getResourceMappedPath(Class componentClass, String resourceFileName, FacesContext context) {
        HttpServletRequest request = null;
        if (context != null) {
            request = (HttpServletRequest)context.getExternalContext().getRequest();
        }
        return AddResource.getResourceMappedPath(AddResource.getComponentName(componentClass), resourceFileName, request);
    }

    private static String getResourceMappedPath(String componentName, String resourceFileName, HttpServletRequest request) {
        String contextPath = "";
        if (request != null) {
            contextPath = request.getContextPath();
        }
        return contextPath + RESOURCE_VIRUAL_PATH + "/" + componentName + '/' + resourceFileName;
    }

    public static boolean isResourceMappedPath(HttpServletRequest request) {
        return request.getRequestURI().indexOf(RESOURCE_VIRUAL_PATH) != -1;
    }

    private static String[] getResourceInfoFromPath(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String componentNameStartsAfter = "/faces/myFacesExtensionResource/";
        int posStartComponentName = uri.indexOf(componentNameStartsAfter) + componentNameStartsAfter.length();
        int posEndComponentName = uri.indexOf("/", posStartComponentName);
        String componentName = uri.substring(posStartComponentName, posEndComponentName);
        String resourceFileName = uri.substring(posEndComponentName + 1);
        return new String[]{componentName, resourceFileName};
    }

    private static String getComponentName(Class componentClass) {
        String name = componentClass.getName();
        if (!name.startsWith(COMPONENTS_PACKAGE)) {
            log.error((Object)("getComponentName called for non extension component : " + name + "\n" + "For security reasons, only components member of the " + COMPONENTS_PACKAGE + " are allowed to add ressources."));
            return null;
        }
        name = name.substring(COMPONENTS_PACKAGE.length());
        return name;
    }

    static Class getComponent(String componentName) throws ClassNotFoundException {
        return Class.forName(COMPONENTS_PACKAGE + componentName);
    }

    /*
     * WARNING - void declaration
     */
    private static InputStream getResource(String componentName, String resourceFileName) {
        void var2_2;
        try {
            Class component = AddResource.getComponent(componentName);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Class not found for component " + componentName));
            return null;
        }
        while (resourceFileName.startsWith(".") || resourceFileName.startsWith("/") || resourceFileName.startsWith("\\")) {
            resourceFileName = resourceFileName.substring(1);
        }
        return var2_2.getResourceAsStream("resource/" + resourceFileName);
    }

    public static void serveResource(HttpServletRequest request, ServletResponse response) throws IOException {
        int c;
        String[] resourceInfo = AddResource.getResourceInfoFromPath(request);
        String componentName = resourceInfo[0];
        String resourceFileName = resourceInfo[1];
        log.debug((Object)("Serving resource " + resourceFileName + " for component " + componentName));
        String lcResourceFileName = resourceFileName.toLowerCase();
        if (lcResourceFileName.endsWith(".js")) {
            response.setContentType("text/javascript");
        } else if (lcResourceFileName.endsWith(".css")) {
            response.setContentType("text/css");
        } else if (lcResourceFileName.endsWith(".gif")) {
            response.setContentType("image/gif");
        } else if (lcResourceFileName.endsWith(".png")) {
            response.setContentType("image/png");
        } else if (lcResourceFileName.endsWith(".jpg") || lcResourceFileName.endsWith(".jpeg")) {
            response.setContentType("image/jpeg");
        } else if (lcResourceFileName.endsWith(".xml")) {
            response.setContentType("text/xml");
        } else if (lcResourceFileName.endsWith(".xsl")) {
            response.setContentType("text/xsl");
        }
        InputStream is = AddResource.getResource(componentName, resourceFileName);
        if (is == null) {
            throw new IOException("Unable to find resource " + resourceFileName + " for component " + componentName + ". Check that this file is available in the classpath in sub-directory /resource of the component-directory.");
        }
        ServletOutputStream os = response.getOutputStream();
        while ((c = is.read()) != -1) {
            os.write(c);
        }
        os.close();
    }

    private static Set getAdditionalHeaderInfoToRender(HttpServletRequest request) {
        LinkedHashSet set = (LinkedHashSet)request.getAttribute(ADDITIONAL_HEADER_INFO_REQUEST_ATTRUBITE_NAME);
        if (set == null) {
            set = new LinkedHashSet();
            request.setAttribute(ADDITIONAL_HEADER_INFO_REQUEST_ATTRUBITE_NAME, set);
        }
        return set;
    }

    private static void addAdditionalHeaderInfoToRender(FacesContext context, AdditionalHeaderInfoToRender info) {
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        Set set = AddResource.getAdditionalHeaderInfoToRender(request);
        set.add(info);
    }

    public static boolean hasAdditionalHeaderInfoToRender(HttpServletRequest request) {
        return request.getAttribute(ADDITIONAL_HEADER_INFO_REQUEST_ATTRUBITE_NAME) != null;
    }

    public static void writeWithFullHeader(HttpServletRequest request, ExtensionsResponseWrapper responseWrapper, HttpServletResponse response) throws IOException {
        String originalResponse = responseWrapper.toString();
        boolean addHeaderTags = false;
        int insertPosition = originalResponse.indexOf("</head>");
        if (insertPosition < 0) {
            insertPosition = originalResponse.indexOf("</HEAD>");
            if (insertPosition < 0) {
                insertPosition = originalResponse.indexOf("<body");
                addHeaderTags = true;
                if (insertPosition < 0) {
                    String lowerCase;
                    insertPosition = originalResponse.indexOf("<BODY");
                    addHeaderTags = true;
                    if (insertPosition < 0 && (insertPosition = (lowerCase = originalResponse.toLowerCase(response.getLocale())).indexOf("</head>")) < 0) {
                        insertPosition = lowerCase.indexOf("<body");
                        addHeaderTags = true;
                    }
                }
            }
            if (insertPosition < 0) {
                log.warn((Object)("Response has no <head> or <body> tag:\n" + originalResponse));
                insertPosition = 0;
            }
        }
        PrintWriter writer = response.getWriter();
        if (insertPosition > 0) {
            writer.write(originalResponse.substring(0, insertPosition));
        }
        if (addHeaderTags) {
            writer.write("<head>");
        }
        Iterator i = AddResource.getAdditionalHeaderInfoToRender(request).iterator();
        while (i.hasNext()) {
            AdditionalHeaderInfoToRender headerInfo = (AdditionalHeaderInfoToRender)i.next();
            writer.write(headerInfo.getString(request));
        }
        if (addHeaderTags) {
            writer.write("</head>");
        }
        writer.write(originalResponse.substring(insertPosition));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AdditionalHeaderInfoToRender {
        static final int TYPE_JS = 0;
        static final int TYPE_CSS = 1;
        static final int TYPE_CSS_INLINE = 2;
        public int type;
        public boolean deferJS = false;
        public String componentName;
        public String resourceFileName;
        public String inlineText;

        public AdditionalHeaderInfoToRender(int infoType, Class componentClass, String resourceFileName) {
            this.type = infoType;
            this.componentName = AddResource.getComponentName(componentClass);
            this.resourceFileName = resourceFileName;
        }

        public AdditionalHeaderInfoToRender(int infoType, Class componentClass, String resourceFileName, boolean defer) {
            if (defer && infoType != 0) {
                log.error((Object)"Defer can only be used for scripts.");
            }
            this.type = infoType;
            this.componentName = AddResource.getComponentName(componentClass);
            this.resourceFileName = resourceFileName;
            this.deferJS = defer;
        }

        public AdditionalHeaderInfoToRender(int infoType, String inlineText) {
            if (infoType != 2) {
                log.error((Object)"This constructor only supports TYPE_CSS_INLINE");
            }
            this.type = infoType;
            this.inlineText = inlineText;
        }

        public int hashCode() {
            return (this.componentName + '\u0007' + this.resourceFileName + '\u0007' + this.type + "" + '\u0007' + this.inlineText + "" + '\u0007' + this.deferJS + "").hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AdditionalHeaderInfoToRender)) {
                return false;
            }
            AdditionalHeaderInfoToRender toCompare = (AdditionalHeaderInfoToRender)obj;
            if (this.type != toCompare.type || this.deferJS != toCompare.deferJS) {
                return false;
            }
            if (this.componentName == null ? toCompare.componentName != null : !this.componentName.equals(toCompare.componentName)) {
                return false;
            }
            if (this.resourceFileName == null ? toCompare.resourceFileName != null : !this.resourceFileName.equals(toCompare.resourceFileName)) {
                return false;
            }
            if (this.inlineText == null) {
                return toCompare.inlineText == null;
            }
            return this.inlineText.equals(toCompare.inlineText);
        }

        public String getString(HttpServletRequest request) {
            switch (this.type) {
                case 0: {
                    return "<script src=\"" + AddResource.getResourceMappedPath(this.componentName, this.resourceFileName, request) + "\" " + (this.deferJS ? "defer=\"true\" " : "") + "type=\"text/javascript\"" + ">" + "</script>\n";
                }
                case 1: {
                    return "<link rel=\"stylesheet\" href=\"" + AddResource.getResourceMappedPath(this.componentName, this.resourceFileName, request) + "\" " + "type=\"text/css\"/>\n";
                }
                case 2: {
                    return "<style type=\"text/css\">" + this.inlineText + "</style>\n";
                }
            }
            log.warn((Object)("Unknown type:" + this.type));
            return "<link href=\"\"/>\n";
        }
    }
}

