/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.datascroller;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.datascroller.HtmlDataScroller;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HtmlRenderer;

public class HtmlDataScrollerRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$datascroller$HtmlDataScrollerRenderer == null ? (class$org$apache$myfaces$custom$datascroller$HtmlDataScrollerRenderer = HtmlDataScrollerRenderer.class$("org.apache.myfaces.custom.datascroller.HtmlDataScrollerRenderer")) : class$org$apache$myfaces$custom$datascroller$HtmlDataScrollerRenderer));
    protected static final String FACET_FIRST = "first".intern();
    protected static final String FACET_PREVOIUS = "previous".intern();
    protected static final String FACET_NEXT = "next".intern();
    protected static final String FACET_LAST = "last".intern();
    protected static final String FACET_FAST_FORWARD = "fastf".intern();
    protected static final String FACET_FAST_REWIND = "fastr".intern();
    protected static final String PAGE_NAVIGATION = "idx".intern();
    public static final String RENDERER_TYPE = "org.apache.myfaces.DataScroller";
    static /* synthetic */ Class class$org$apache$myfaces$custom$datascroller$HtmlDataScrollerRenderer;
    static /* synthetic */ Class class$org$apache$myfaces$custom$datascroller$HtmlDataScroller;
    static /* synthetic */ Class class$javax$faces$component$UIData;

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        RendererUtils.checkParamValidity(context, component, class$org$apache$myfaces$custom$datascroller$HtmlDataScroller == null ? (class$org$apache$myfaces$custom$datascroller$HtmlDataScroller = HtmlDataScrollerRenderer.class$("org.apache.myfaces.custom.datascroller.HtmlDataScroller")) : class$org$apache$myfaces$custom$datascroller$HtmlDataScroller);
        HtmlDataScroller scroller = (HtmlDataScroller)component;
        UIData uiData = this.findUIData(scroller, component);
        if (uiData == null) {
            return;
        }
        Map parameter = context.getExternalContext().getRequestParameterMap();
        String param = (String)parameter.get(component.getClientId(context));
        if (param != null) {
            if (param.equals(FACET_FIRST)) {
                uiData.setFirst(0);
            } else if (param.equals(FACET_PREVOIUS)) {
                int previous = uiData.getFirst() - uiData.getRows();
                if (previous >= 0) {
                    uiData.setFirst(previous);
                }
            } else if (param.equals(FACET_NEXT)) {
                int next = uiData.getFirst() + uiData.getRows();
                if (next < uiData.getRowCount()) {
                    uiData.setFirst(next);
                }
            } else if (param.equals(FACET_FAST_FORWARD)) {
                int rowcount;
                int next;
                int fastStep = scroller.getFastStep();
                if (fastStep <= 0) {
                    fastStep = 1;
                }
                if ((next = uiData.getFirst() + uiData.getRows() * fastStep) > (rowcount = uiData.getRowCount())) {
                    next = rowcount - 1 - (rowcount - 1) % uiData.getRows();
                }
                uiData.setFirst(next);
            } else if (param.equals(FACET_FAST_REWIND)) {
                int previous;
                int fastStep = scroller.getFastStep();
                if (fastStep <= 0) {
                    fastStep = 1;
                }
                if ((previous = uiData.getFirst() - uiData.getRows() * fastStep) < 0) {
                    previous = 0;
                }
                uiData.setFirst(previous);
            } else if (param.equals(FACET_LAST)) {
                int first;
                int rows;
                int rowcount = uiData.getRowCount();
                int delta = rowcount % (rows = uiData.getRows());
                int n = first = delta > 0 && delta < rows ? rowcount - delta : rowcount - rows;
                if (first >= 0) {
                    uiData.setFirst(first);
                } else {
                    uiData.setFirst(0);
                }
            } else if (param.startsWith(PAGE_NAVIGATION)) {
                int pageCount;
                int index = Integer.parseInt(param.substring(PAGE_NAVIGATION.length(), param.length()));
                if (index > (pageCount = this.getPageCount(uiData))) {
                    index = pageCount;
                } else if (index <= 0) {
                    index = 1;
                }
                uiData.setFirst(uiData.getRows() * (index - 1));
            }
        }
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
        String lastRowIndexVar;
        String firstRowIndexVar;
        String displayedRowsCountVar;
        String rowsCountVar;
        String pageIndexVar;
        RendererUtils.checkParamValidity(facescontext, uicomponent, class$org$apache$myfaces$custom$datascroller$HtmlDataScroller == null ? (class$org$apache$myfaces$custom$datascroller$HtmlDataScroller = HtmlDataScrollerRenderer.class$("org.apache.myfaces.custom.datascroller.HtmlDataScroller")) : class$org$apache$myfaces$custom$datascroller$HtmlDataScroller);
        Map requestMap = facescontext.getExternalContext().getRequestMap();
        HtmlDataScroller scroller = (HtmlDataScroller)uicomponent;
        UIData uiData = this.findUIData(scroller, uicomponent);
        if (uiData == null) {
            return;
        }
        String pageCountVar = scroller.getPageCountVar();
        if (pageCountVar != null) {
            int pageCount = this.getPageCount(uiData);
            requestMap.put(pageCountVar, new Integer(pageCount));
        }
        if ((pageIndexVar = scroller.getPageIndexVar()) != null) {
            int pageIndex = this.getPageIndex(uiData);
            requestMap.put(pageIndexVar, new Integer(pageIndex));
        }
        if ((rowsCountVar = scroller.getRowsCountVar()) != null) {
            int rowsCount = uiData.getRowCount();
            requestMap.put(rowsCountVar, new Integer(rowsCount));
        }
        if ((displayedRowsCountVar = scroller.getDisplayedRowsCountVar()) != null) {
            int max;
            int displayedRowsCount = uiData.getRows();
            if (displayedRowsCount > (max = uiData.getRowCount() - uiData.getFirst())) {
                displayedRowsCount = max;
            }
            requestMap.put(displayedRowsCountVar, new Integer(displayedRowsCount));
        }
        if ((firstRowIndexVar = scroller.getFirstRowIndexVar()) != null) {
            int firstRowIndex = uiData.getFirst() + 1;
            requestMap.put(firstRowIndexVar, new Integer(firstRowIndex));
        }
        if ((lastRowIndexVar = scroller.getLastRowIndexVar()) != null) {
            int count;
            int lastRowIndex = uiData.getFirst() + uiData.getRows();
            if (lastRowIndex > (count = uiData.getRowCount())) {
                lastRowIndex = count;
            }
            requestMap.put(lastRowIndexVar, new Integer(lastRowIndex));
        }
        RendererUtils.renderChildren(facescontext, uicomponent);
        if (pageCountVar != null) {
            requestMap.remove(pageCountVar);
        }
        if (pageIndexVar != null) {
            requestMap.remove(pageIndexVar);
        }
        if (rowsCountVar != null) {
            requestMap.remove(rowsCountVar);
        }
        if (displayedRowsCountVar != null) {
            requestMap.remove(displayedRowsCountVar);
        }
        if (firstRowIndexVar != null) {
            requestMap.remove(firstRowIndexVar);
        }
        if (lastRowIndexVar != null) {
            requestMap.remove(lastRowIndexVar);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String style;
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$datascroller$HtmlDataScroller == null ? (class$org$apache$myfaces$custom$datascroller$HtmlDataScroller = HtmlDataScrollerRenderer.class$("org.apache.myfaces.custom.datascroller.HtmlDataScroller")) : class$org$apache$myfaces$custom$datascroller$HtmlDataScroller);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlDataScroller scroller = (HtmlDataScroller)uiComponent;
        UIData uiData = this.findUIData(scroller, uiComponent);
        if (uiData == null) {
            return;
        }
        writer.startElement("table", scroller);
        String styleClass = scroller.getStyleClass();
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, null);
        }
        if ((style = scroller.getStyle()) != null) {
            writer.writeAttribute("style", style, null);
        }
        writer.startElement("tr", scroller);
        UIComponent facetComp = scroller.getFirst();
        if (facetComp != null) {
            writer.startElement("td", scroller);
            this.renderFacet(facesContext, scroller, facetComp, FACET_FIRST);
            writer.endElement("td");
        }
        if ((facetComp = scroller.getFastRewind()) != null) {
            writer.startElement("td", scroller);
            this.renderFacet(facesContext, scroller, facetComp, FACET_FAST_REWIND);
            writer.endElement("td");
        }
        if ((facetComp = scroller.getPrevious()) != null) {
            writer.startElement("td", scroller);
            this.renderFacet(facesContext, scroller, facetComp, FACET_PREVOIUS);
            writer.endElement("td");
        }
        if (scroller.isPaginator()) {
            writer.startElement("td", scroller);
            this.renderPaginator(facesContext, scroller, uiData);
            writer.endElement("td");
        }
        if ((facetComp = scroller.getNext()) != null) {
            writer.startElement("td", scroller);
            this.renderFacet(facesContext, scroller, facetComp, FACET_NEXT);
            writer.endElement("td");
        }
        if ((facetComp = scroller.getFastForward()) != null) {
            writer.startElement("td", scroller);
            this.renderFacet(facesContext, scroller, facetComp, FACET_FAST_FORWARD);
            writer.endElement("td");
        }
        if ((facetComp = scroller.getLast()) != null) {
            writer.startElement("td", scroller);
            this.renderFacet(facesContext, scroller, facetComp, FACET_LAST);
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("table");
    }

    private void renderFacet(FacesContext facesContext, HtmlDataScroller scroller, UIComponent facetComp, String facetName) throws IOException {
        HtmlCommandLink link = this.getLink(facesContext, scroller, facetComp, facetName);
        ((UIComponent)link).encodeBegin(facesContext);
        facetComp.encodeBegin(facesContext);
        if (facetComp.getRendersChildren()) {
            facetComp.encodeChildren(facesContext);
        }
        facetComp.encodeEnd(facesContext);
        ((UIComponent)link).encodeEnd(facesContext);
    }

    protected void renderPaginator(FacesContext facesContext, HtmlDataScroller scroller, UIData uiData) throws IOException {
        String style;
        int start;
        int pages;
        int pageCount;
        ResponseWriter writer = facesContext.getResponseWriter();
        int maxPages = scroller.getPaginatorMaxPages();
        if (maxPages <= 1) {
            maxPages = 2;
        }
        if ((pageCount = this.getPageCount(uiData)) <= 1) {
            return;
        }
        int pageIndex = this.getPageIndex(uiData);
        int delta = maxPages / 2;
        if (pageCount > maxPages && pageIndex > delta) {
            pages = maxPages;
            start = pageIndex - pages / 2 - 1;
            if (start + pages > pageCount) {
                start = pageCount - pages;
            }
        } else {
            pages = pageCount < maxPages ? pageCount : maxPages;
            start = 0;
        }
        writer.startElement("table", scroller);
        String styleClass = scroller.getPaginatorTableClass();
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, null);
        }
        if ((style = scroller.getPaginatorTableStyle()) != null) {
            writer.writeAttribute("style", style, null);
        }
        writer.startElement("tr", scroller);
        int size = start + pages;
        for (int i = start; i < size; ++i) {
            String cStyle;
            String cStyleClass;
            int idx = i + 1;
            writer.startElement("td", scroller);
            if (idx == pageIndex) {
                cStyleClass = scroller.getPaginatorActiveColumnClass();
                cStyle = scroller.getPaginatorActiveColumnStyle();
            } else {
                cStyleClass = scroller.getPaginatorColumnClass();
                cStyle = scroller.getPaginatorColumnStyle();
            }
            if (cStyleClass != null) {
                writer.writeAttribute("class", cStyleClass, null);
            }
            if (cStyle != null) {
                writer.writeAttribute("style", cStyle, null);
            }
            HtmlCommandLink link = this.getLink(facesContext, scroller, Integer.toString(idx), idx);
            link.encodeBegin(facesContext);
            link.encodeChildren(facesContext);
            link.encodeEnd(facesContext);
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("table");
    }

    protected HtmlCommandLink getLink(FacesContext facesContext, HtmlDataScroller scroller, String text, int pageIndex) {
        String id = PAGE_NAVIGATION + Integer.toString(pageIndex);
        Application application = facesContext.getApplication();
        HtmlCommandLink link = (HtmlCommandLink)application.createComponent("javax.faces.HtmlCommandLink");
        link.setId(scroller.getId() + id);
        link.setTransient(true);
        UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
        parameter.setId(scroller.getId() + id + "_param");
        parameter.setTransient(true);
        parameter.setName(scroller.getClientId(facesContext));
        parameter.setValue(id);
        List children = link.getChildren();
        children.add(parameter);
        if (text != null) {
            HtmlOutputText uiText = (HtmlOutputText)application.createComponent("javax.faces.HtmlOutputText");
            uiText.setTransient(true);
            uiText.setValue(text);
            children.add(uiText);
        }
        scroller.getChildren().add(link);
        return link;
    }

    protected HtmlCommandLink getLink(FacesContext facesContext, HtmlDataScroller scroller, UIComponent facetComp, String facetName) {
        Application application = facesContext.getApplication();
        HtmlCommandLink link = (HtmlCommandLink)application.createComponent("javax.faces.HtmlCommandLink");
        link.setId(scroller.getId() + facetName);
        link.setTransient(true);
        UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
        parameter.setId(scroller.getId() + facetName + "_param");
        parameter.setTransient(true);
        parameter.setName(scroller.getClientId(facesContext));
        parameter.setValue(facetName);
        List children = link.getChildren();
        children.add(parameter);
        if (facetComp != null) {
            children.add(facetComp);
        }
        scroller.getChildren().add(link);
        return link;
    }

    protected int getPageIndex(UIData uiData) {
        int pageIndex;
        int rows = uiData.getRows();
        if (rows > 0) {
            pageIndex = uiData.getFirst() / rows + 1;
        } else {
            log.warn((Object)("DataTable " + uiData.getClientId(FacesContext.getCurrentInstance()) + " has invalid rows attribute."));
            pageIndex = 0;
        }
        if (uiData.getFirst() % rows > 0) {
            ++pageIndex;
        }
        return pageIndex;
    }

    protected int getPageCount(UIData uiData) {
        int pageCount;
        int rows = uiData.getRows();
        if (rows > 0) {
            int n = pageCount = rows <= 0 ? 1 : uiData.getRowCount() / rows;
            if (uiData.getRowCount() % rows > 0) {
                ++pageCount;
            }
        } else {
            rows = 1;
            pageCount = 1;
        }
        return pageCount;
    }

    protected UIData findUIData(HtmlDataScroller scroller, UIComponent component) {
        UIComponent forComp;
        String forStr = scroller.getFor();
        if (forStr == null) {
            forComp = component.getParent();
        } else {
            forComp = component.findComponent(scroller.getFor());
            if (forComp == null) {
                log.warn((Object)("could not find UIData referenced by attribute dataScroller@for = '" + scroller.getFor() + "'"));
            }
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("uiComponent referenced by attribute tableScroller@for must be of type " + (class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlDataScrollerRenderer.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData).getName());
        }
        return (UIData)forComp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

