/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.render.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import javax.faces.render.Renderer;
import org.seasar.jsf.exception.NoSelectItemRuntimeException;
import org.seasar.jsf.util.UIValueUtil;

public class HtmlSelectRenderer
extends Renderer {
    protected void renderSelectOptions(FacesContext context, UIOutput component, List selectItemList, List lookupAsString) throws IOException {
        Iterator it = selectItemList.iterator();
        while (it.hasNext()) {
            SelectItem selectItem = (SelectItem)it.next();
            this.renderSelectItem(context, component, selectItem, lookupAsString);
        }
    }

    protected void renderSelectItem(FacesContext context, UIOutput component, SelectItem selectItem, List lookupAsString) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = component.getConverter();
        if (selectItem instanceof SelectItemGroup) {
            writer.startElement("optgroup", null);
            writer.writeAttribute("label", (Object)selectItem.getLabel(), null);
            SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
            this.renderSelectOptions(context, component, Arrays.asList(selectItems), lookupAsString);
            writer.endElement("optgroup");
        } else {
            Object itemValue = selectItem.getValue();
            String itemStrValue = UIValueUtil.getValueAsString(context, (UIComponent)component, itemValue, converter);
            writer.write("\t\t");
            writer.startElement("option", null);
            if (itemStrValue != null) {
                writer.writeAttribute("value", (Object)itemStrValue, null);
            }
            if (lookupAsString.contains(itemStrValue)) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            writer.writeText((Object)selectItem.getLabel(), null);
            if (selectItem.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            writer.endElement("option");
        }
    }

    protected List getSelectItemList(UIComponent component) {
        ArrayList list = new ArrayList(component.getChildCount());
        Iterator children = component.getChildren().iterator();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            if (child instanceof UISelectItem) {
                this.addSelectItem(list, (UISelectItem)child);
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            this.addSelectItems(list, (UISelectItems)child);
        }
        return list;
    }

    protected void addSelectItem(List list, UISelectItem component) {
        Object value = component.getValue();
        if (value != null) {
            this.addIfSelectItem(list, value, (UIComponent)component);
        } else {
            Object itemValue = component.getItemValue();
            String label = component.getItemLabel();
            String description = component.getItemDescription();
            boolean disabled = component.isItemDisabled();
            SelectItem selectItem = this.createSelectItem(itemValue, label, description, disabled);
            list.add(selectItem);
        }
    }

    protected void addIfSelectItem(List list, Object value, UIComponent component) {
        if (!(value instanceof SelectItem)) {
            FacesContext context = FacesContext.getCurrentInstance();
            String clientId = component.getClientId(context);
            throw new NoSelectItemRuntimeException(clientId);
        }
        list.add(value);
    }

    protected SelectItem createSelectItem(Object value, String label, String description, boolean disabled) {
        if (label == null && value != null) {
            label = value.toString();
        }
        SelectItem selectItem = new SelectItem();
        if (value != null) {
            selectItem.setValue(value);
        }
        if (label != null) {
            selectItem.setLabel(label);
        }
        selectItem.setDescription(description);
        selectItem.setDisabled(disabled);
        return selectItem;
    }

    protected void addSelectItems(List list, UISelectItems component) {
        Object value = component.getValue();
        if (value instanceof SelectItem) {
            list.add(value);
        } else if (value instanceof SelectItem[]) {
            SelectItem[] items = (SelectItem[])value;
            int i = 0;
            while (i < items.length) {
                list.add(items[i]);
                ++i;
            }
        } else if (value instanceof Collection) {
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                Object item = it.next();
                this.addIfSelectItem(list, item, (UIComponent)component);
            }
        } else {
            FacesContext context = FacesContext.getCurrentInstance();
            String clientId = component.getClientId(context);
            throw new NoSelectItemRuntimeException(clientId);
        }
    }
}

