package org.seasar.jsf.util;

import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author higa
 *  
 */
public class ExternalContextUtil {

	private ExternalContextUtil() {
	}

	public static String getViewId(ExternalContext externalContext) {
		String viewId = externalContext.getRequestPathInfo();
		if (viewId == null) {
			viewId = externalContext.getRequestServletPath();
			String defaultSuffix = externalContext
					.getInitParameter(ViewHandler.DEFAULT_SUFFIX_PARAM_NAME);
			String suffix = defaultSuffix != null ? defaultSuffix
					: ViewHandler.DEFAULT_SUFFIX;
			int dot = viewId.lastIndexOf('.');
			if (dot >= 0) {
				viewId = viewId.substring(0, dot) + suffix;
			}
		}

		return viewId;
	}
	
	public static HttpServletRequest getRequest(ExternalContext externalContext) {
		return (HttpServletRequest) externalContext.getRequest();
	}
	
	public static HttpServletResponse getResponse(ExternalContext externalContext) {
		return (HttpServletResponse) externalContext.getResponse();
	}
}